/* マイク入力を使ったサンプル */
let mic;    //マイク（p5.AudioInクラスのインスタンス）
let isListening = false;  //マイクで音を取得中かどうか

function setup(){
  let canvas = createCanvas(windowWidth, windowHeight);   //canvasのインスタンスを取得
  mic = new p5.AudioIn();
  canvas.mousePressed(startAudio);    //canvas上でマウスが押されたら自作関数のstartAudioが呼ばれる
}
function draw(){
  background(0);

  let level = mic.getLevel();   //マイクの入力レベルを取得
  let r = 50 + level * 2000;     //円の半径を決める
  fill(0, 255, 0);
  circle(width/2, height/2, r*2);

  //再生中でなければ三角形を描く
  fill(255);
  noStroke();
  if(isListening != true){
    let x = width/2;
    let y = height/2;
    triangle(x-50, y-50, x-50, y+50, x+35, y);
  }
}
//画面上でマウスが押されたらこの関数が呼ばれ、音の収集が始まる
function startAudio(){
  if(isListening != true){
    mic.start();
    mic.amp(1.0);
    isListening = true;
  }
}
//ブラウザのセキュリティ対策
function touchStarted() {
    userStartAudio();
}
