/* 音の解析 */
let soundFile;    //音声ファイル
let fft;  //音を解析するためのクラス（「高速フーリエ変換 fast Fourier transform」の略）

function preload(){
  soundFile = loadSound("data/sound.wav");
}
function setup(){
  let canvas = createCanvas(windowWidth, windowHeight);
  canvas.mousePressed(toggleSound);  //マウスが押されたらtoggleSoundという自作関数を呼ぶ
  fft = new p5.FFT();   //音を解析するためのクラスを初期化
}
function draw(){
  background(0);

  //スペクトルを描く
  let spectrum = fft.analyze();     //今出てる音を解析してスペクトルを取得する
  noStroke();
  fill(255, 0, 255);
  for(let i = 0; i < spectrum.length; i++){
    let x = i / spectrum.length * width;
    let h = spectrum[i] / 255 * height;
    rect(x, height - h, width/spectrum.length, h);
  }

  //波形を描く（先にfft.analyze()がされている必要がある
  let waveform = fft.waveform();    //波形を取得
  noFill();
  stroke(255, 255, 0);
  beginShape();
  for(let i = 0; i < waveform.length; i++){
    let x = i / waveform.length * width;
    let y = waveform[i] * height + height/2;
    vertex(x, y);
  }
  endShape();

  //再生中でなければ三角形を描く
  fill(255);
  noStroke();
  if(soundFile.isPlaying() != true){
    let x = width/2;
    let y = height/2;
    triangle(x-50, y-50, x-50, y+50, x+35, y);
  }
}
//マウスが押されたら呼ばれる、音をON/OFFする関数
function toggleSound(){
  if(soundFile.isPlaying() != true){
    soundFile.play();  //一度だけ再生
    soundFile.setVolume(0.5);  //音量。0〜1.0
  }else{
    soundFile.stop();  //音を停止
  }
}
//ブラウザのセキュリティ対策
function touchStarted() {
    userStartAudio();
}
