/* オシレーターを使ったサイン波の出力 */

let osc;             //オシレーター
let isPlaying = false;    //音を再生中かどうか
let hz = 1000;       //出したい周波数を入れておく変数

function setup() {
  let canvas = createCanvas(windowWidth, windowHeight);
  canvas.mousePressed(toggleSound);  //マウスが押されたらtoggleSoundという自作関数を呼ぶ
  osc = new p5.Oscillator("sine");    //オシレーターのインスタンスを作り、波形のタイプをサイン波に指定する
}
function draw() {
  background(0);
  hz = mouseX / width * 10000;    //画面幅に対するマウスのX座標の相対的な割合で周波数を決める
  osc.freq(hz);       //オシレーターの周波数を決定する
  //再生していないときは三角形を出す
  fill(255);
  if(isPlaying != true){
    let x = width/2;
    let y = height/2;
    triangle(x-50, y-50, x-50, y+50, x+35, y);
  }
}
//マウスが押されたら呼ばれる、音をON/OFFする関数
function toggleSound(){
  if(isPlaying != true){
    osc.start();  //音を出し始める
    osc.amp(0.2); //音量を設定する（0〜1.0）
    isPlaying = true;   //「再生中かどうか」をtrueに
  }else{
    osc.stop();   //音を止める
    isPlaying = false;   //「再生中かどうか」をfalseに
  }
}
//ブラウザのセキュリティ対策
function touchStarted() {
    userStartAudio();
}
