/* マウスの座標と画面の中心との距離によって音をパンしたり音量を変えたりする */
let soundFile;             //音声ファイルを入れる箱

function preload() {
  soundFormats('wav');  //wav拡張子を読み込めるようにする
  soundFile = loadSound("data/mahiwa.wav");  //音声ファイルを読み込み
}
function setup() {
  let canvas = createCanvas(windowWidth, windowHeight);
  canvas.mousePressed(playSound);   //マウスが押されたらplaySoundという自作関数を呼ぶ
}
function draw() {
  background(0);
  //音声ファイルが再生中なら、画面の中心とマウスとの距離・角度を計算し、それに応じたボリュームとパンで音を出す
  if(soundFile.isPlaying() == true){
    let x = width/2;    //パンと音量を決めるための基準点の座標
    let y = height/2;
    let angle = atan2(y - mouseY, x - mouseX);  //マウスとx, yとの角度を測る
    let distance = dist(x, y, mouseX, mouseY);  //マウスとx, yの距離を測る
    //x, yとマウスの距離が、音がなり始める半径より小さくなったら音量とパン度合いを計算する
    let r = 500;        //音がなり始める半径
    if (distance < r) {
      let volume = (r - distance) / r;  //ボリュームを、2点が近くなるに連れて大きくなるよう計算。
      let pan = cos(angle);  //パン度合い
      soundFile.setVolume(volume);    //音量を設定
      soundFile.pan(pan);       //パンを設定（-1.0〜1.0）
    } else {
      soundFile.setVolume(0.001);      //音量を下げる
    }
  }
  //説明用
  fill(255);
  if(soundFile.isPlaying() != true){
    let x = width/2;
    let y = height/2;
    triangle(x-50, y-50, x-50, y+50, x+35, y);
  }else{
    text("カーソルを画面の中心にゆっくり近づけてみてください", 50, height-50);
  }
}
function playSound(){
  //マウスを押したら音の再生を始める（ブラウザのセキュリティで、何らかのユーザ入力がなければ音を再生できないため）
  if(soundFile.isPlaying() != true){
    soundFile.play();  //一度だけ再生
    soundFile.setVolume(0);  //音量。0〜1.0
  }
}
//ブラウザのセキュリティ対策
function touchStarted() {
    userStartAudio();
}
