let mode = 1; //描くモード

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。

  strokeWeight(20);
  strokeCap(SQUARE);
  stroke(122, 40, 0);
  noFill();
  line(304, 265, 308, 453);
  line(101, 134, 304, 265);
  line(489, 114, 304, 265);
  line(98, 180, 153, 171);
  line(173, 80, 218, 212);
  line(228, 87, 199, 152);
  line(440, 74, 370, 212);
  line(371, 74, 398, 152);
  line(512, 165, 415, 175);
  line(177, 552, 308, 453);
  line(281, 552, 308, 453);
  line(437, 543, 308, 453);

  //説明文
  fill(255, 255, 255);
  noStroke();
  text("1か2のキーを押すとモードが変わります", 20, 580);
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
  if (mouseIsPressed) {
    //モードが1の時の時は緑の丸を描く
    if (mode == 1) {
      fill(0, 200, 0);
      noStroke();
      circle(mouseX, mouseY, random(10, 30));
    }
    //モードが2の時は黄色い円を描く
    if (mode == 2) {
      fill(255, 255, 0);
      noStroke();
      circle(mouseX, mouseY, random(10, 30));
    }
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  //キーが押されたらモードを変える
  if (key == "1") {
    mode = 1;
  }
  if (key == "2") {
    mode = 2;
  }
  if (key == "s") {
    saveCanvas();
  }
}
