let x = 200; //目のX座標
let speedX = 1; //xのスピードとして使う変数

let wh = 50; //口のサイズ（円弧の大きさ）
let speedWh = 1; //whのスピードとして使う変数

let mayuW = 20; //まゆげの太さ
let speedMayuW = 1; //まゆげの太さのスピードとして使う変数

function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して1回だけ塗る。
}

function draw() {
  background(0, 0, 0, 10); //背景色を指定して1回だけ塗る。

  //顔の輪郭
  noStroke();
  fill(255);
  circle(300, 300, 500);

  //まゆげ
  strokeWeight(mayuW); //まゆげの太さを設定
  stroke(0);
  noFill();
  line(100, 150, 250, 150);
  line(350, 150, 500, 150);

  strokeWeight(1);

  //はな
  stroke(0);
  noFill();
  line(300, 200, 350, 400);

  //左目
  noStroke();
  fill(255, 0, 0);
  circle(x, 250, 100);

  //右目
  noStroke();
  fill(0, 0, 255);
  circle(x + 180, 250, 100);

  //口（円弧を二つ繋げて描く）
  noFill();
  stroke(0);
  angleMode(DEGREES);
  arc(300, 425, wh, wh, 270, 90);
  arc(300, 425 + wh, wh, wh, 270, 90);

  //目のX座標を変化させる
  x = x + speedX; //「x」に「speedX」の値を足す
  //「x」の値が一定の値を超えたら、「speedX」の値を変える
  if (x > 280) {
    speedX = -1;
  }
  if (x < 200) {
    speedX = 1;
  }

  //まゆげの太さを変化させる
  mayuW = mayuW + speedMayuW;
  if (mayuW > 80) {
    speedMayuW = -1;
  }
  if (mayuW < 20) {
    speedMayuW = 1;
  }

  //口のサイズを変化させる
  wh = wh + speedWh;
  if (wh > 100) {
    speedWh = -1;
  }
  if (wh < 25) {
    speedWh = 1;
  }
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
