function setup() {
  createCanvas(600, 600); //ウィンドウサイズの指定
  background(0, 0, 0); //背景色を指定して塗りつぶす。

  //左上の図======================================
  stroke(255, 0, 0);
  noFill();
  //beginShape()からendShape()で囲った間にvertex(x, y)で頂点を打つと多角形が書ける。
  beginShape();
  vertex(50, 100); //始点を打つ
  vertex(150, 50); //現在の点から引数の点まで直線を引く
  vertex(250, 200); //現在の点から引数の点まで直線を引く
  vertex(200, 300); //現在の点から引数の点まで直線を引く
  vertex(50, 250); //現在の点から引数の点まで直線を引く
  endShape(CLOSE); //CLOSEだと最後の点から最初の点を結んで形態を閉じる

  //右上の図======================================
  stroke(255, 255, 0);
  noFill();
  beginShape();
  vertex(400, 100);
  vertex(500, 50);
  vertex(600, 200);
  vertex(550, 300);
  vertex(400, 250);
  endShape(); //引数に何も書かないと最後の点と最初の点を結ばず、形態を閉じない。

  //左下の図====================================
  noStroke();
  fill(50, 50, 255);
  beginShape();
  vertex(24, 420); //始点を打つ
  bezierVertex(26, 408, 28, 388, 60, 388); //現在の点からベジェ曲線を引く。引数は制御点1の(x,y), 制御点2(x,y), 終点(x,y)の6つ。
  bezierVertex(91, 388, 80, 374, 119, 374);
  bezierVertex(158, 374, 143, 401, 174, 401);
  bezierVertex(205, 401, 206, 389, 241, 389);
  bezierVertex(276, 389, 286, 416, 286, 425);
  bezierVertex(286, 435, 287, 510, 238, 509);
  bezierVertex(190, 509, 238, 469, 190, 469);
  bezierVertex(149, 469, 165, 534, 116, 534);
  bezierVertex(96, 534, 87, 519, 90, 499);
  bezierVertex(94, 479, 116, 465, 103, 449);
  bezierVertex(87, 429, 67, 458, 46, 458);
  bezierVertex(23, 458, 22, 432, 24, 420);
  endShape();

  //右下の図====================================
  stroke(255, 0, 255);
  noFill();
  beginShape();
  vertex(342, 353);
  bezierVertex(358, 354, 383, 346, 441, 346);
  bezierVertex(491, 346, 540, 374, 540, 402);
  bezierVertex(540, 446, 437, 459, 437, 531);
  bezierVertex(437, 578, 473, 581, 487, 581);
  bezierVertex(499, 581, 552, 575, 552, 495);
  bezierVertex(552, 446, 494, 425, 494, 371);
  bezierVertex(494, 318, 552, 345, 552, 379);
  bezierVertex(552, 411, 519, 438, 488, 432);
  bezierVertex(458, 432, 369, 419, 369, 312);
  endShape();
}

function draw() {
  // background(0, 0, 0); //背景色を指定して1回だけ塗る。
}

function mousePressed() {
  //マウスのボタンが押し下げられた時の処理
}

function mouseReleased() {
  //マウスのボタンが離された時の処理
}

function keyPressed() {
  if (key == "s") {
    saveCanvas();
  }
}
