let pt;
let isPressed = false;

function setup() {
  createCanvas(windowWidth, windowHeight);
  pt = new PhysicalPoint();
  pt.setPoint(width/2, height/2);  //初期座標を画面の中心に。setPointするとその座標がptの内部のox, oyに保存されるので、のちのちホームポジションとして使うことができる。
}

function draw() {
  background(0, 0, 0);
  //マウスに対する距離、角度を計算する
  let kakudo = pt.angleTo(mouseX, mouseY);    //引数のx, y座標への角度を返す
  let kyori = pt.distanceTo(mouseX, mouseY);    //引数のx, y座標への距離を返す
  //もし距離が近くなれば
  let r = 200;            //有効範囲を200に設定
  if (kyori < r) {          //もし有効範囲より距離が近くなれば
    let a = r - kyori;    //与える加速度の計算。距離が近いほど力が強くなるようにするため、有効範囲との差をとる
    if (isPressed != true) {    //マウスを押していない間は
      let xpow = a*100 * cos(kakudo+PI);
      let ypow = a*100 * sin(kakudo+PI);
      pt.setAcceleration(xpow, ypow);  //マウスと反対方向に加速度を与える（逃げる）
    } else {                    //マウスを押している間は
      let xpow = a*500 * cos(kakudo);
      let ypow = a*500 * sin(kakudo);
      pt.setAccelerationTo(xpow, ypow);     //マウスの方向に加速度を与える（吸い付く）
    }
  }
  pt.setAccelerationTo(pt.ox, pt.oy, 200);  //ホームポジションに向けても加速度を与える
  pt.update();  //位置計算をさせる
  noStroke();
  if(isPressed != true){
    fill(100, 255, 0);
  }else {
    fill(255, 100, 100);
  }
  ellipse(pt.x, pt.y, 100, 100);
}
function mousePressed() {
  isPressed = true;
}
function mouseReleased() {
  isPressed = false;
}
function touchStarted(){
  isPressed = true;
}
function touchMoved(){
  return false;
}
function touchEnded(){
  isPressed = false;
}
