/* 物理法則を使った動き */
let pt;           //PhysicalPointクラスのインスタンスを入れるオブジェクト
let ax = 50000;  //x方向に与える加速度
let ay = 30000;  //y方向に与える加速度

function setup(){
  createCanvas(windowWidth, windowHeight);
  pt = new PhysicalPoint();
  pt.setPoint(0, 0);  //ptのx, y座標を設定する
}
function draw(){
  background(0, 0, 0);
  pt.update();    //ptに位置計算をさせる
  noStroke();
  fill(100, 255, 0);
  ellipse(pt.x, pt.y, 100, 100);    //ptのx, yを使って円を描画

  //壁に当たったら跳ね返る（おまけ）
  if(pt.x < 0 || pt.x > width){
    pt.vx *= -1;    //ptのx方向の速さを反対向きに
    ax *= -1;       //ptのx方向に与える加速度を反対向きに
    //壁にめり込んだptを壁の外に出す
    if(pt.x < 0){
      pt.x = -1 * pt.x;
    }else{
      pt.x = width - (pt.x - width);
    }
  }
  if(pt.y < 0 || pt.y > height){
    pt.vy *= -1;    //ptのy方向の速さを反対向きに
    ay *= -1;       //ptのy方向に与える加速度を反対向きに
    //壁にめり込んだptを壁の外に出す
    if(pt.y < 0){
      pt.y = -1 * pt.y;
    }else{
      pt.y = height - (pt.y - height);
    }
  }
}
function mousePressed(){
  pt.setAcceleration(ax, ay);   //ptにax, ayの加速度を与える
}
function touchStarted(){
  pt.setAcceleration(ax, ay);   //ptにax, ayの加速度を与える
}
function touchMoved(){
  return false;
}
