/* 「クラス」を使う体験をしながらインベーダーゲームを作るサンプル */
let invader;                           //Invaderクラスのインスタンスを入れるオブジェクト
let myX = 300;                       //自機のx座標
let myY = 700;                       //自機のy座標
let tamaX = new Array(100);          //弾のx座標を入れる配列
let tamaY = new Array(tamaX.length);        //弾のy座標を入れる配列
let tamaNum = 0;                       //発射すべき弾番号

function setup() {
  createCanvas(windowWidth, windowHeight);
  invader = new Invader();
  invader.x = width/2;
  invader.y = 50;
  //弾のx, y座標の初期化。画面外に置く。
  for (let i = 0; i < tamaX.length; i++) {
    tamaX[i] = -999;
    tamaY[i] = -999;
  }
}

function draw() {
  background(0);
  myX = mouseX;    //自機のx座標は常にマウスのx座標にする

  //弾の位置計算
  for (let i = 0; i < tamaX.length; i++) {
    tamaY[i] = tamaY[i] - 2;
  }
  //弾とインベーダーの当たり判定。もし当たっていれば弾の座標を画面外に置いて消えたことにする。
  for (let i = 0; i < tamaX.length; i++) {
    let atatta = invader.checkAtari(tamaX[i], tamaY[i]);
    if (atatta == true) {
      tamaY[i] = -999;
    }
  }
  //インベーダーの描画
  invader.drawInvader();
  //自機の描画
  fill(255, 100, 100);
  triangle(myX, myY, myX-10, myY+15, myX+10, myY+15);
  //弾の描画
  fill(255, 255, 100 );
  for (let i = 0; i < tamaX.length; i++) {
    ellipse(tamaX[i], tamaY[i], 5, 5);
  }
}

function mousePressed() {
  //マウスが押されたら、発射すべき番号「tamaNum」の弾を自機の座標に移動させる
  tamaX[tamaNum] = myX;
  tamaY[tamaNum] = myY;
  //発射すべき弾の番号を1つずらし、次回は次の番号の弾が発射されるようにする。
  tamaNum = tamaNum + 1;
  if (tamaNum > tamaX.length-1) {
    tamaNum = 0;
  }
}
