/*
画面を地図として、看板の座標を設定する。
マウスが移動すると、マウスの周りに看板の文字が表示させる。
文字の大きさは看板に近づくほど大きくなる。
*/
let messages = ["飛び出し注意", "セブンイレブンいい気分", "紅久商店", "シンフォニアテクノロジー", "しんぶん赤旗", "おかしのチップス", "ココカラファイン", "HOTEL ユアーズ", "この先急カーブ", "727 COSMETICS", "くぐるな あぶない", "進入禁止", "危険！後退注意", "止まれ", "立入禁止", "米", "ひなん場所", "40"];    //看板の文字
let x = new Array(messages.length);  //座標を看板の文字と同じだけ作る
let y = new Array(messages.length);
let font;

function setup() {
  createCanvas(windowWidth, windowHeight);
  //看板の座標の初期化。画面内にランダムで配置する。
  for (let i = 0; i < messages.length; i++) {
    x[i] = random(width);
    y[i] = random(height);
  }
  font = "YuMinchoStd-M";
  textFont(font);
}

function draw() {
  background(0);
  for (let i = 0; i < messages.length; i++) {
    let kakudo = atan2(y[i]-mouseY, x[i]-mouseX);  //マウスから各看板への角度を計算する
    let xdist = x[i]-mouseX;    //2点のx座標の差
    let ydist = y[i]-mouseY;    //2点のy座標の差
    let kyori = sqrt(pow(xdist, 2) + pow(ydist, 2));  //マウスと各看板の距離を計算する。三平方の定理（a^2 + b^2 = c^2）から。
//    let distance = dist(mouseX, mouseY, x[i], y[i]);        //マウスと各看板の距離を計算する（processingのdist()関数を使う）

    //マウスと各看板の距離が300以内ならその文字を描画する。描く場所はマウスから各看板の方向に100離れた点とする。
    if (kyori < 300) {
      let r = 100;                             //マウスと描画する点との距離
      let mx = mouseX + r * cos(kakudo);       //極座標を使い、中心点、半径、角度からx, y座標を求める
      let my = mouseY + r * sin(kakudo);
      let fSize = (300 - kyori) / 5.0;         //距離が近づくほど大きくなるようにフォントサイズを計算する
      let alpha = (300 - kyori) / 300 * 255;   //距離が近づくほど明るくなるように透明度を計算する
      fill(255, alpha);
      textSize(fSize);
      text(messages[i], mx, my);                 //文字の描画
    }
  }
}
