//中心点の周りを回転する点をPとする
let cx;  //回転の中心のx座標
let cy;  //回転の中心のy座標
let r = 300;    //回転の中心
let angle;  //回転角度

function setup() {
  createCanvas(windowWidth, windowHeight);
  cx = width/2;    //回転の中心を画面の中央に
  cy = height/2;
  angle = PI*2;
}
function draw(){
  background(0);
  noStroke();
  fill(200, 200, 0);
  ellipse(cx, cy, 50, 50);  //回転中心を描く
  let x = cx + r * cos(angle);  //三角関数より、中心から点Pまでのxの長さは半径×コサイン（角度）
  let y = cy + r * sin(angle);  //同じく、中心から点Pまでのyの長さはyの長さは半径×サイン（角度）

  cx = cx + (mouseX - cx)/10.0;   //回転の中心をマウスに徐々に近づける
  cy = cy + (mouseY - cy)/10.0;
  stroke(255);
  line(cx, cy, x, y);
  noStroke();
  fill(200, 0, 200);
  ellipse(x, y, 100, 100);  //中心の周りを回転する点Pの描画
  angle = angle + 0.1;   //回転角度を増やす（回すため）
}
