//大きくなる円（配列）

let x = new Array(5);  //円の中心x座標を入れる配列
let y = new Array(x.length);  //円の中心y座標を入れる配列
let r = new Array(x.length);   //円の半径
let sat = new Array(x.length);  //円の彩度

function setup() {
  createCanvas(windowWidth, windowHeight);
  colorMode(HSB);
  let haba = 800;                       //5つの円を表示する領域の幅
  let margin = haba / (x.length-1);     //円どうしのマージンを計算する
  let leftX = width/2 - haba/2;         //一番左の円のx座標
  //円の座標、半径、彩度の初期化
  for (let i = 0; i < x.length; i=i+1) {  //円の数だけ繰り返す
     x[i] = leftX + i * margin;           //一番左の円のx座標から、それぞれの円の番号に比例したx座標を割り出す
     y[i] = height/2;                     //y座標は一律で画面の中心に
     r[i] = 50;                           //半径は最初50に
     sat[i] = 0.0;                        //彩度は最初0に
  }
}
function draw() {
  background(0);
  //円のマウス判定========================================================
  for (let i = 0; i < x.length; i=i+1) {
    if (dist(x[i], y[i], mouseX, mouseY) < r[i]) {  //円の中にマウスが入ったら（dist()は2点の距離を返す変数）
      r[i] = r[i] + (200 - r[i]) / 20.0;            //円を大きくする（半径を200に近づける）
      sat[i] = sat[i] + (200 - sat[i]) / 20.0;      //彩度を上げる
    } else {                                        //それ以外の場合
      r[i] = r[i] + (50 - r[i]) / 20.0;             //円を小さくする（半径を50に近づける）
      sat[i] = sat[i] + (0 - sat[i]) / 20.0;        //彩度を下げる
    }
    //円の描画========================================================
    noStroke();
    fill(i * 255/x.length, sat[i], 255);
    ellipse(x[i], y[i], r[i]*2, r[i]*2);
  }
}
