let x = new Array(100);        //それぞれの円のx座標
let y = new Array(x.length);   //それぞれの円のy座標
let addX = new Array(x.length);   //それぞれの円の1フレームごとのx移動量
let addY = new Array(x.length);   //それぞれの円の1フレームごとのy移動量

function setup() {
  createCanvas(windowWidth, windowHeight);

  for (let i = 0; i < x.length; i++) {    //配列の要素数だけ繰り返しを作る
    x[i] = random(0, width);      //現在のループ回数を示す「i」を使って全ての要素を初期化する。random(a, b)はaからbの間のランダム値を得る。
    y[i] = random(0, height);
    addX[i] = random(-4, 4);      //x, y同様、移動量もランダムで値を入れる
    addY[i] = random(-4, 4);
  }
}

function draw() {
  background(0);
  noStroke();
  fill(200, 200, 0);
  for (let i = 0; i < x.length; i++) {  //配列の要素数だけ繰り返す
    ellipse(x[i], y[i], 100, 100);      //現在のループ回数「i」を使って円を順番に描く
    x[i] = x[i] + addX[i];    //x座標に移動量を加える
    y[i] = y[i] + addY[i];
    if(x[i] < 0 || x[i] > width){    //もしx座標が左右の壁を超えてしまったら
      addX[i] = addX[i] * -1;        //移動量の正負を逆向きにする
    }
    if(y[i] < 0 || y[i] > height){
      addY[i] = addY[i] * -1;
    }
  }
}
