//改行の方法2種類
let font;
let st = "月日は\n百代の過客にして、\n行きかふ年もまた\n旅人なり。";      //「\n」を入れると改行される（「\」はoption+¥で入力）
let st2 = "月日は百代の過客にして、行きかふ年もまた旅人なり。舟の上に生涯を浮かべ、馬の口とらへて老いを迎ふる者は、日々旅にして旅を栖とす。古人も多く旅に死せるあり。";      //改行なしテキスト
let x = 100;
let y = 100;
let fSize = 36;
let leading = 100;

let x2 = 600;
let y2 = y;
let w2 = 300;
let h2 = 500;
let fSize2 = 18;
let leading2 = 50;

function setup () {
  createCanvas(windowWidth, windowHeight);
  colorMode(HSB);
  font = "HiraMinPro-W3";
  textFont(font);
}

function draw () {
  background(0);

  //改行あり文字列を普通に描画する================================================================================
  fill(60, 200, 255);
  noStroke();
  textAlign(LEFT);
  textSize(fSize);
  textLeading(leading);        //行間の指定（textSize()より後にやる必要がある）
  text(st, x, y);

  //改行なし文字列を矩形の中に収まるように描画する==================================================================
  fill(60, 200, 255);
  noStroke();
  textSize(fSize2);
  textLeading(leading2);      //行間の指定（textSize()より後にやる必要がある）
  w2 = mouseX - x2;
  h2 = mouseY - y2;
  //  text(st2, x2, y2, w2, h2);        //(x2, y2)を左上の頂点とした幅・高さ(w2, h2)の矩形に収まるようにテキストを描画。欧文の場合はこれでよい
  drawJTextInBox(st2, x2, y2, w2, h2, false);        //(x2, y2)を左上の頂点とした幅・高さ(w2, h2)の矩形に収まるようにテキストを描画。最後の引数はラギッドにするかどうか
  stroke(160, 200, 255);
  noFill();
  rect(x2, y2, w2, h2);             //矩形の描画


  //説明用テキスト=================================================================================
  noStroke();
  fill(160, 200, 255);
  ellipse(x, y, 6, 6);   //始点に点を打つ
  textSize(12);
  text("(" + x + ", " + y + ")", x, y+15);       //x, yの値を描画

  textSize(14);
  text("textSize(" + fSize + ");\ntextLeading(" + leading + ");\ntext(st, " + x + "," + y + ");", x, height-80);  //画面下部の説明文

  noStroke();
  fill(160, 200, 255);
  ellipse(x2, y2, 6, 6);   //始点に点を打つ
  textSize(12);
  text("(" + x2 + ", " + y2 + ")", x2, y2-12);    //x2, y2の値を描画

  textAlign(CENTER);
  text("w=" + w2, x2 + w2/2, y2-12);            //幅w2の値
  textAlign(LEFT);
  text("h=" + h2, x2 + w2 + 10, y2 + h2/2);     //高さh2の値

  textSize(14);
  text("texeSize(" + fSize2 + ");\ntextLeading(" + leading2 + ");\ndrawJTextInBox(st, " + x2 + "," + y2 + "," + w2 + "," + h2 + ", false);", x2, height-80);  //画面下部の説明文
}

//日本語テキストを自動改行するためのメソッド
function drawJTextInBox(st, x, y, w, h, ragged = false){
  if(w > 0){
    let n = 0;
    let lines = new Array();
    let lineW = 0;
    while(n < st.length){
      if(n==0){
        lines.push({"chars":[], "width":0.0});
      }
      let curLine = lines[lines.length-1];
      let char = st.charAt(n);
      let charW = textWidth(char);
      if(lineW + charW < w){
        lineW += charW;
        curLine["chars"].push(char);
        curLine["width"] = lineW;
      }else{
        lineW = charW;
        lines.push({"chars":[], "width":lineW});
        lines[lines.length-1]["chars"].push(char);
      }
      n++;
    }
    y += textAscent() + textDescent();
    for(let i = 0; i < lines.length; i++){
      let curX = x;
      const chars = lines[i]["chars"];
      let spacing = (w - lines[i]["width"]) / (chars.length-1);
      if(i == lines.length-1 || ragged == true){
        spacing = 0.0;
      }
      for(let j = 0; j < chars.length; j++){
        const char = chars[j];
        text(char, curX, y);
        curX += textWidth(char) + spacing;
      }
      y += textLeading();
    }
  }
}
