//現在のフォントにおける文字の各要素の取得。文字の描画領域とマウスインタラクション。
let font_en;    //欧文用フォント
let font_ja;    //和文用フォント
let font;       //説明用フォント
let x = 200;    //欧文を描く用のx座標
let y = 400;    //欧文を描く用のy座標
let x2 = 550;   //和文を描く用のx座標
let y2 = y;     //和文を描く用のy座標
let w;          //欧文の幅
let h;          //欧文の高さ
let w2;         //和文の幅
let h2;         //和文の高さ
let as;         //欧文のアセント
let ds;         //欧文のディセント
let as2;        //和文のアセンと
let ds2;        //欧文のディセント
let drag_en = false;    //欧文をドラッグ中かどうか
let drag_ja = false;    //和文をドラッグ中かどうか

function setup() {
  createCanvas(windowWidth, windowHeight);
  font_en = "GaramondPremrPro";
  textFont(font_en, 48);    //欧文フォントの指定
  font_ja = "YuMinchoStd-M";
  textFont(font_ja, 48);       //和文フォントの指定
  font = "LucidaGrande";
  textFont(font, 12);           //説明用フォントの指定
  print(font_en);
}

function draw() {
  background(0);

  //左上の説明文====================================================================================
  textFont(font);
  textSize(14);
  noStroke();
  fill(200, 0, 0);
  text("textAscent()", 50, 50);
  fill(200, 200, 0);
  text("textDescent()", 50, 70);
  fill(0, 200, 200);
  text("textWidth(st)", 50, 90);

  //欧文===========================================================================================

  let st = "adj";
  textFont(font_en);
  textSize(100);
  textAlign(LEFT, BASELINE);

  w = textWidth(st);    //現在のフォント設定で文字列stの幅を取得
  as = textAscent();    //アセント（ベースラインから上の高さ）を取得
  ds = textDescent();   //ディセント（ベースライン以下の高さ）を取得
  h = as + ds;          //高さはアセントにディセントを足した値

  //ドラッグ処理------------------------------------------------------------------------------------
  if (drag_en == true) {                    //ドラッグ中だったら（判定はmousePressed()の中で）
    x = x + (mouseX-w/2 - x) / 10.0;        //xをmouseXに近づける
    y = y + (mouseY-ds+h/2 - y) / 10.0;     //yをmouseYに近づける
    fill(255, 255, 0);
    noStroke();
    rect(x, y-as, w, h);                    //文字の背面を塗りつぶす
  }

  // マウスオーバーでテキスト領域をハイライト-----------------------------------------------------------
  if (drag_en != true) {                    //ドラッグ中ではなかったら（判定はmousePressed()の中で）
    if (x <= mouseX && mouseX <= x+w && y-as <= mouseY && mouseY <= y+ds) {    //マウスが文字の描画領域の中にあれば（マウスオーバーしていれば）
      fill(0, 0, 200);
      noStroke();
      rect(x, y-as, w, h);                  //文字の背面を塗りつぶす
    }
  }

  //ベースラインの位置に文字幅の線を引く---------------------------------------------------------------
  noFill();
  stroke(0, 200, 200);
  line(x, y, x+w, y);

  //アセントの線を引く------------------------------------------------------------------------------
  stroke(200, 0, 0);
  line(x, y-as, x, y);

  //ディセントの線を引く----------------------------------------------------------------------------
  stroke(200, 200, 0);
  line(x, y, x, y+ds);

  //文字の描画-------------------------------------------------------------------------------------
  fill(255);
  if (drag_en == true) {                   //ドラッグ中は白抜きにする
    fill(0);
  }
  noStroke();
  text(st, x, y);                          //テキストの描画

  //和文===========================================================================================

  st = "お蕎麦";
  textFont(font_ja);
  textSize(100);

  w2 = textWidth(st);    //現在のフォント設定で文字列stの幅を取得
  as2 = textAscent();    //アセント（ベースラインから上の高さ）を取得
  ds2 = textDescent();    //ディセント（ベースライン以下の高さ）を取得
  h2 = as2 + ds2;

  //ドラッグ処理------------------------------------------------------------------------------------
  if (drag_ja == true) {
    x2 = x2 + (mouseX-w2/2 - x2) / 10.0;
    y2 = y2 + (mouseY-ds2+h2/2 - y2) / 10.0;
    fill(255, 255, 0);
    noStroke();
    rect(x2, y2-as2, w2, h2);
  }
  // マウスオーバーでテキスト領域をハイライト-----------------------------------------------------------
  if (drag_ja != true && x2 <= mouseX && mouseX <= x2+w2 && y2-as2 <= mouseY && mouseY <= y2+ds2) {
    fill(0, 0, 200);
    noStroke();
    rect(x2, y2-as2, w2, h2);
  }
  //ベースラインの位置に文字幅の線を引く---------------------------------------------------------------
  noFill();
  stroke(0, 200, 200);
  line(x2, y2, x2+w2, y2);

  //アセントの線を引く------------------------------------------------------------------------------
  stroke(200, 0, 0);
  line(x2, y2-as2, x2, y2);

  //ディセントの線を引く----------------------------------------------------------------------------
  stroke(200, 200, 0);
  line(x2, y2, x2, y2+ds2);

  //文字の描画-------------------------------------------------------------------------------------
  fill(255);
  if (drag_ja == true) {
    fill(0);
  }
  noStroke();
  text(st, x2, y2);
}

function mousePressed() {        //マウスが押し下げられた時
  //欧文
  if (x <= mouseX && mouseX <= x + w && y-as <= mouseY && mouseY < y + ds) {  //文字の描画領域の中にマウスがあれば
    drag_en = true;          //ドラッグ中かどうかのフラグをONに
  }
  //和文
  if (x2 <= mouseX && mouseX <= x2 + w2 && y2-as2 <= mouseY && mouseY < y2 + ds2) {  //文字の描画領域の中にマウスがあれば
    drag_ja = true;          //ドラッグ中かどうかのフラグをONに
  }
}
function mouseReleased() {       //マウスが離された時
  drag_en = false;           //ドラッグ中かどうかのフラグをOFFに
  drag_ja = false;           //ドラッグ中かどうかのフラグをOFFに
}
