let invaders = new Array(105);  //インベーダーのインスタンスを入れる配列
let addX = 1.0;    //インベーダーの移動量

let tamaX = new Array(50);    //自機から出た弾のx座標（配列の長さは弾の数）
let tamaY = new Array(tamaX.length);    //自機から出た弾のy座標
let curTama = 0;                  //次に発射する弾の番号

let jibunY = 700;          //自機のy座標
let jibunX = 0;            //自機のx座標
let jibunDead = false;   //自機が死んだかどうか

function setup() {
  createCanvas(windowWidth, windowHeight);

  //インベーダーの初期化と初期座標を決める=====================
  let leftX = 50;     //左端のx座標
  let curX = leftX;    //暫定のx座標
  let curY = 50;       //暫定のy座標
  for (let i = 0; i < invaders.length; i++) {
    invaders[i] = new Invader();  //配列の要素を初期化する（コンストラクタが呼ばれる）
    invaders[i].x = curX;        //初期座標として暫定x座標を代入
    invaders[i].y = curY;        //初期座標として暫定y座標を代入
    invaders[i].num = i;         //各自の番号を教える
    curX += 50;                  //暫定x座標を増やす
    if (curX >= 800) {           //暫定x座標が800を超えたら
      curX = leftX;              //暫定x座標を左端に戻す
      curY += 50;                //暫定y座標を増やして次の行に移行させる
    }
  }
}

function draw() {
  background(0);

  jibunX = mouseX;    //自機のx座標をマウスのx座標と同期させる

  //インベーダーの座標計算==========================================
  let minX = 9999;     //全インベーダーのうち最小のx座標を調べるための変数。初期値として異常に大きい値を入れておく
  let maxX = -9999;    //全インベーダーのうち最大のx座標を調べるための変数。初期値として異常に小さい値を入れておく
  for (let i = 0; i < invaders.length; i++) {
    if (!invaders[i].isDead) {
      invaders[i].x += addX;        //各インベーダーを移動
      invaders[i].update();         //敵弾の座標を計算させる
      invaders[i].drawInvader();    //各インベーダーを描画
      for (let j = 0; j < tamaX.length; j++) {        //自機の弾を全部調べる
        let atatta = invaders[i].intersects(tamaX[j], tamaY[j]);  //インベーダーが自機の弾に当たったかどうかを調べる）
        if (atatta) {                   //もし当たったら
          invaders[i].isDead = true;    //インベーダーを死んだことにする
          tamaY[j] = -100;              //当たった弾を画面外に持っていく（と消えたように見える）
        }
      }
      //敵弾と自機との衝突判定
      if (jibunX-12 <= invaders[i].tamaX && invaders[i].tamaX <= jibunX+12 && jibunY <= invaders[i].tamaY && invaders[i].tamaY <= jibunY + 12) {
        jibunDead = true;
      }
      minX = min(invaders[i].x, minX);    //暫定の最小値とインベーダーのx座標をmin()で比べて、小さい方を取っておく。
      maxX = max(invaders[i].x+invaders[i].w, maxX);    //暫定の最大値とインベーダーのx座標をmax()で比べて、大きい方を取っておく。
    }
  }
  if (minX < 50) {    //もしインベーダーの左端が50より小さくなったら
    addX *= -1;      //インベーダーの移動方向を逆に
    for (let i = 0; i < invaders.length; i++) {  //全インベーダーを下に少し移動させる
      invaders[i].y += 2;
    }
  }
  if (maxX > width - 50) {    //もしインベーダーの右端が画面端-50より小さくなったら
    addX *= -1;
    for (let i = 0; i < invaders.length; i++) {
      invaders[i].y += 2;
    }
  }

  //自機の弾の描画=======================================
  for (let i = 0; i < tamaX.length; i++) {
    fill(255, 100, 100);
    ellipse(tamaX[i], tamaY[i], 4, 4);    //弾の描画
    tamaY[i] -= 2;               //弾を上に移動させる
  }

  //自機の描画==========================================
  if (!jibunDead) {    //もしまだ死んでいなければ
    fill(0, 0, 200);
    triangle(jibunX, jibunY, jibunX+12, jibunY + 12, jibunX - 12, jibunY + 12);
  } else {             //もう死んでいれば
    textSize(102);
    textAlign(CENTER, CENTER);
    fill(255, 0, 0);
    text("DEAD", width/2, height/2);    //ゲームオーバーメッセージの描画
  }
}

function mousePressed() {
  //自機からの弾の発射
  if (!jibunDead) {
    tamaX[curTama] = jibunX;        //現在の弾番号の弾を自機の位置に。
    tamaY[curTama] = jibunY;
    curTama += 1;                   //現在の弾番号を1ずらす
    if (curTama >= tamaX.length) {  //現在の弾番号が弾数より多くなってしまったら0に戻す
      curTama = 0;
    }
  }
}

function touchStarted() {
  //自機からの弾の発射
  if (!jibunDead) {
    tamaX[curTama] = jibunX;        //現在の弾番号の弾を自機の位置に。
    tamaY[curTama] = jibunY;
    curTama += 1;                   //現在の弾番号を1ずらす
    if (curTama >= tamaX.length) {  //現在の弾番号が弾数より多くなってしまったら0に戻す
      curTama = 0;
    }
  }
}
function touchMoved(){
  return false;
}
