class PhysicalPoint {

  //コンストラクタ
  constructor(_x, _y = 0) {
    this.preTime = new Date().getMilliseconds();
    this.b = 0.90;  //摩擦係数
    this.vx = 0;  //x（初）速度
    this.vy = 0;  //y（初）速度
    this.ax = 0;  //x加速度
    this.ay = 0;  //y加速度
    this.x = _x;  //現在のx座標
    this.y = _y;  //現在のy座標
    this.ox = _x;  //ホームポジションのx座標
    this.oy = _y;  //ホームポジションのx座標
  }
  //座標を更新する（メインスケッチのdraw()内で呼ぶ必要がある）
  update() {
    let curTime = new Date().getMilliseconds();  //現在時刻をミリ秒単位で取得
    if(curTime < this.preTime){
      this.preTime -= 1000;
    }
    let t = (curTime - this.preTime) * 0.001;  //前フレームの時刻から現在時刻を引いて経過時間を計算
    if (t > 0.066) t = 0.066;

    this.x += this.vx * t + 0.5 * this.ax * t * t;  //現在の速度、加速度と経過時間から現在位置を計算
    this.y += this.vy * t + 0.5 * this.ay * t * t;

    this.vx += this.ax * t;  //現在の速度を加速度から算出
    this.vy += this.ay * t;

    this.vx *= this.b;  //速度に摩擦係数を与える
    this.vy *= this.b;

    this.ax = 0;  //加速度を0にする
    this.ay = 0;

    this.preTime = curTime;  //次フレームのために現フレームの時刻を保存しておく。
  }
  //初期座標を設定する（ホームポジションの座標も設定される）
  setPoint(_x, _y) {
    this.x = _x;
    this.y = _y;
    this.ox = this.x;
    this.oy = this.y;
  }
  //加速度を与える
  setAcceleration(_ax, _ay) {
    this.ax += _ax;
    this.ay += _ay;
  }
  //目的のx, y座標に向かって加速度を与える
  setAccelerationTo(_x, _y, power) {
    this.setAcceleration((_x - this.x) * power, (_y - this.y) * power);
  }
  //摩擦係数の変更
  setFriction(_b) {
    this.b = _b;
  }
  //現在地からx1, y1への距離を取得
  distanceTo(x1, y1) {
    let dist =  Math.sqrt((x1 - this.x) * (x1 - this.x) + (y1 - this.y) * (y1 - this.y));
    return dist;
  }
  //現在地からx1, y1への角度を取得
  angleTo(x1, y1) {
    let angle = 0.0;
    if (this.x == x1) {
      if (this.y < y1)  return PI/2.0;
      if (this.y > y1)  return -PI/2.0;
      if (this.y == y1)  return 0.0;
    }
    angle = Math.atan((y1-this.y)/(x1-this.x));
    if (this.x > x1)  angle -= PI;
    if (angle < 0.0)  angle += PI*2.0;
    if (angle > PI*2.0)  angle -= PI*2.0;
    return angle;
  }
  //速度、加速度を0にする
  resetAcceleration() {
    this.ax = 0;
    this.ay = 0;
    this.vx = 0;
    this.vy = 0;
  }
}
