let pt = new Array(100);  //配列ptを宣言

function setup() {
  createCanvas(windowWidth, windowHeight);
  //点群をマトリックス状に配置===============================
  let margin = 50;    //点間の間隔
  let leftX = width/2 - margin * 9/2;  //左端のx座標
  let topY = height/2 - margin * 9/2;  //上端のy座標
  let curX = leftX;    //現在のx座標
  let curY = topY;    //現在のy座標
  for (let i = 0; i < pt.length; i++) {
    //各ptの初期化
    pt[i] = new PhysicalPoint(curX, curY);  //現在のx, y座標でptを初期化
    curX += margin;    //現在のx座標に間隔を足す
    if(curX >= leftX + margin * 10){  //もし現在のx座標が右端まで行ってしまったら
      curX = leftX;    //現在のx座標を左端に戻す
      curY += margin;  //現在のy座標に間隔を足す
    }
  }
}

function draw() {
  background(0);

  for (let i = 0; i < pt.length; i++) {
    pt[i].update();  //ptの現在の座標を計算

    //マウスが吸い込むような動き====================================
    let dist = pt[i].distanceTo(mouseX, mouseY);  //ptとマウスとの距離を取得
    //有効範囲200pxとして、マウスとの距離に反比例して力が強くなるよう計算
    let range = 200;
    let r = 0;
    if (dist < range) {
      r = range-dist;
    }
    //マウスに対する角度を計算し、マウスに向かって加速度を加える
    let angle = pt[i].angleTo(mouseX, mouseY);
    let xpow = r*40 * cos(angle);
    let ypow = r*40 * sin(angle);
    pt[i].setAcceleration(xpow, ypow);

    //ホームポジションに向かって力を加える==========================
    pt[i].setAccelerationTo(pt[i].ox, pt[i].oy, 100);

    noStroke();
    fill(0, 0, 255, 200);
    let velo = sqrt(pow(pt[i].vx, 2) + pow(pt[i].vy,2));  //x, yの合成速度を計算
    ellipse(pt[i].x, pt[i].y, 10 + velo * 0.1, 10 + velo * 0.1);
  }
}
