let pt = new Array(1000);  //PhysicalPointの配列を宣言・初期化

function setup() {
  createCanvas(windowWidth, windowHeight);
  for (let i = 0; i < pt.length; i++) {
    //各ptの初期化。0から画面の幅、高さまででランダムに座標を設定する
    pt[i] = new PhysicalPoint(random(width), random(height));
  }
}

function draw() {
  background(0);

  noStroke();
  for (let i = 0; i < pt.length; i++) {
    //現在座標を更新
    pt[i].update();

    //マウスから逃げる動き===========================================
    let dist = pt[i].distanceTo(mouseX, mouseY);  //マウスとの距離
    //有効範囲200pxとして、マウスとの距離が近いほど力が強くなるよう計算
    let r = 200 - dist;
    if (r < 0) {
      r = 0;
    }
    //マウスに対する角度から180度を引いて、マウスとの逆方向を計算する
    let angle = pt[i].angleTo(mouseX, mouseY) - PI;
    let xpow = r*100 * cos(angle);
    let ypow = r*100 * sin(angle);
    pt[i].setAcceleration(xpow, ypow);

    let velo = sqrt(pow(pt[i].vx, 2) + pow(pt[i].vy, 2));  //ptのx, y速度の合成を求める（sqrt()は平方根、pow(a, n)はaのn乗を求める
    fill(50, 255 - velo, 50 + velo, 200);
    ellipse(pt[i].x, pt[i].y, 20, 20);
  }
}
