let pt;  //PhysicalPointクラスのオブジェクトptを宣言

function setup() {
  createCanvas(windowWidth, windowHeight);
  //ptを初期化。初期座標に画面の中心座標を設定する
  pt = new PhysicalPoint(width/2, height/2);
}
let i = 0;
function draw() {
  background(0);

  pt.update();  //ptの現在の座標を計算

  //マウスが吸い込むような動き====================================
  let dist = pt.distanceTo(mouseX, mouseY);  //ptとマウスとの距離を取得
  //有効範囲300pxとして、マウスとの距離が近いほど力が強くなるよう計算
  let range = 300;
  let r = 0;
  if (dist < range) {
    r = 100 * (range-dist);
  }
  //マウスに対する角度を計算し、マウスに向かって加速度を加える
  let angle = pt.angleTo(mouseX, mouseY);
  let xpow = r * cos(angle);
  let ypow = r * sin(angle);
  pt.setAcceleration(xpow, ypow);

  let velo = sqrt(pow(pt.vx, 2) + pow(pt.vy, 2));
  noStroke();
  fill(50 + velo, 255 - velo, 50);
  ellipse(pt.x, pt.y, 100, 100);
}
