let pt;  //PhysicalPointクラスのインスタンスptを宣言
let addX, addY;  //円に加えるx方向、y方向の力

function setup() {
  createCanvas(windowWidth, windowHeight);
  pt = new PhysicalPoint(0, height/2);  //ptを初期化
  addX = 50000;
  addY = 40000;
}

function draw() {
  background(0);
  pt.update();  //ptの座標を更新

  //跳ね返り処理
  if (pt.x > width || pt.x < 0) {
    addX = addX * -1;  //与える加速度を正負逆向きに
    pt.vx = pt.vx * -1;    //現在の速度を正負逆向きに
    //点が壁より先に行っている場合があるので、壁より手前に移動させる
    if (pt.x > width) {
      pt.x = width - (pt.x - width);
    } else {
      pt.x = -pt.x;
    }
  }
  if (pt.y > height || pt.y < 0) {
    addY = addY * -1;
    pt.vy = pt.vy * -1;
    if (pt.y > height) {
      pt.y = height - (pt.y - height);
    } else {
      pt.y = -pt.y;
    }
  }
  //描画
  noStroke();
  fill(50, 50, 255);
  ellipse(pt.x, pt.y, 30, 30);  //ptのx, yの位置に円を描く
}

function mousePressed() {
  pt.setAcceleration(addX, addY);  //マウスをクリックするとx方向に50000、y方向に0の力を加える
}
function touchStarted(){
  pt.setAcceleration(addX, addY);  //マウスをクリックするとx方向に50000、y方向に0の力を加える
}
function touchMoved(){
  return false;
}
