let s;  //SVGデータを格納するためのオブジェクト
let x;  //SVG図形を描くx座標
let y;  //SVG図形を描くy座標
let w;  //SVG図形を描く幅
let h;  //SVG図形を描く高さ
let ow;  //オリジナルのSVGデータの幅（illustratorのアートボードの大きさ）
let oh;  //オリジナルのSVGデータの高さ（illustratorのアートボードの大きさ）

let ss;
let xx;  //SVG図形を描くx座標
let yy;  //SVG図形を描くy座標
let ww;  //SVG図形を描く幅
let hh;  //SVG図形を描く高さ
let oww;  //オリジナルのSVGデータの幅（illustratorのアートボードの大きさ）
let ohh;  //オリジナルのSVGデータの高さ（illustratorのアートボードの大きさ）

function preload(){
  //svgデータの読み込み（SVGデータは一番大きくしたいサイズで作ること。p5.jsは画像としてどうやら読み込むため、元データを超えると粗くなる）
  s = loadImage("data/insect.svg");

  //ネイティブのJSを使ったsvgデータの読み込み（こちらはどれだけ大きくしても粗くならないが、パスが複雑になると重くなる）
  ss = new Image();
  ss.src = "data/insect.svg";
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  ow = s.width;  //オリジナルの幅を取得
  oh = s.height;  //オリジナルの高さを取得
  w = 0.0;
  h = 0.0;

  oww = ss.width;
  ohh = ss.height;
  ww = 0.0;
  hh = 0.0;
}

function draw() {
  background(0);

  //p5.jsのloadImage()で読み込んだSVGを描く=============================================================
  x = width/4;
  y = height/2;
  //マウスで触ったら拡大、マウスが離れたら元の大きさに
  if (x - w/2 < mouseX && mouseX < x + w/2 && y - h/2 < mouseY && mouseY < y + h/2) {
    w += (ow * 2.0 - w) / 10.0;  //オリジナルの幅の2倍にゆっくり近づける
    h += (oh * 2.0 - h) / 10.0;  //オリジナルの高さの2倍にゆっくり近づける
    fill(100, 255, 100);
  } else {
    w += (ow / 5.0 - w) / 10.0;  //オリジナルの幅の1/5にゆっくり近づける
    h += (oh / 5.0 - h) / 10.0;  //オリジナルの高さの1/5にゆっくり近づける
    noFill();
  }
  image(s, x - w/2, y - h/2, w, h);  //SVG図形を描く。

  fill(255);
  noStroke();
  textAlign(CENTER);
  text("p5.jsのloadImage()で読み込んだSVG\n元の大きさは" + ow + "×" + oh + "\n今の大きさは" + int(w) + "×" + int(h), x, height-100);

  //ネイティヴのJSで読み込んだSVGを描く=============================================================
  xx = width/2 + width/4;
  yy = height/2;
  //マウスで触ったら拡大、マウスが離れたら元の大きさに
  if (xx - ww/2 < mouseX && mouseX < xx + ww/2 && yy - hh/2 < mouseY && mouseY < yy + hh/2) {
    ww += (oww * 2.0 - ww) / 10.0;  //オリジナルの幅の2倍にゆっくり近づける
    hh += (ohh * 2.0 - hh) / 10.0;  //オリジナルの高さの2倍にゆっくり近づける
    fill(100, 255, 100);
  } else {
    ww += (oww / 5.0 - ww) / 10.0;  //オリジナルの幅の1/5にゆっくり近づける
    hh += (ohh / 5.0 - hh) / 10.0;  //オリジナルの高さの1/5にゆっくり近づける
    noFill();
  }
  let canvas = document.getElementById("defaultCanvas0"); //キャンバスを取得
  let ctx = canvas.getContext("2d");                      //2Dコンテクストを取得
  ctx.drawImage(ss, xx - ww/2, yy - hh/2, ww, hh);        //2Dコンテクスト内にsvgを直接描く

  fill(255);
  noStroke();
  textAlign(CENTER);
  text("ネイティヴのJSで書いたSVG\n元の大きさは" + oww + "×" + ohh + "\n今の大きさは" + int(ww) + "×" + int(hh), xx, height-100);
}
