//毎時の風向データ
let fuukou = [
  "南", "南", "南", "南", "南", "南",
  "南", "南南西", "南", "南", "南", "南南西",
  "南", "南南東", "南", "南南西", "南南西", "南",
  "南南西", "南", "南", "南", "南", "南"
];
//毎時の風速データ
let fuusoku = [
  8.4, 7.6, 7.5, 7.3, 6.0, 6.2,
  6.4, 8.2, 8.1, 8.2, 8.7, 7.4,
  7.3, 7.8, 5.8, 8.2, 7.8, 6.4,
  5.4, 4.0, 5.1, 5.0, 5.3, 6.4
];
let maxFuusoku = 0.0;   //最大風速を入れる変数
let minFuusoku = 99.9;  //最小風速を入れる変数

let x = new Array(24);          //毎時の矢印の先端のx座標
let y = new Array(x.length);    //毎時の矢印の先端のy座標

let r = 200;            //円の半径
let ctX;     //中心点の座標
let ctY;

let curTime = 0;      //現在の時間
let lastTime = 0;     //1フレーム前の時間
let passedTime = 0;   //実行開始からの経過時間

function setup() {
  createCanvas(windowWidth, windowHeight);

  ctX = width/2;
  ctY = height/2;

  //最大風速、最小風速の算出
  for (let i = 0; i < fuusoku.length; i++) {
    maxFuusoku = max(fuusoku[i], maxFuusoku);     //現在の暫定最大風速と毎時の風速を比べて最大値を取る
    minFuusoku = min(fuusoku[i], minFuusoku);     //現在の暫定最小風速と毎時の風速を比べて最大値を取る
  }
  //各矢印の始点を算出する
  for (let i = 0; i < x.length; i++) {
    let angle = PI * 2 / x.length * i - PI/2;
    x[i] = ctX + r * cos(angle);
    y[i] = ctY + r * sin(angle);
  }
  curTime = millis();    //現在の時間をミリ秒で取得
  lastTime = curTime;    //1フレーム前の時間を現在の時間と同じにする
}

function draw() {

  curTime = millis();    //毎フレーム、現在の時間を取得する
  passedTime += curTime - lastTime;      //1フレーム前の時間と現在の時間との差分をとり、プログラム開始からの経過時間に加える

  background(0);

  //○時の描画
  noStroke();
  fill(255);
  for (let i = 0; i < x.length; i++) {
    let angle = PI * 2 / x.length * i - PI/2;
    let xx = ctX + r * cos(angle);
    let yy = ctY + r * sin(angle);
    text(i+1, xx, yy);
  }

  //矢印の描画
  stroke(255);
  noFill();
  for (let i = 0; i < fuukou.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    //風向データを角度に変換する（このデータの場合、風向が3種類しかないので3つしか条件判定していない）
    let direction = 0.0;
    if (fuukou[i] == "南") {
      direction = PI/2;
    } else if (fuukou[i] == "南南西") {
      direction = PI/2 + PI/16;
    } else if (fuukou[i] == "南南東") {
      direction = PI/2 - PI/16;
    }

    let x1 = ctX + r * cos(angle);    //矢印の始点
    let y1 = ctY + r * sin(angle);
    let r2 = (200 / (maxFuusoku - minFuusoku)) * (fuusoku[i] - minFuusoku);  //毎時の風速と最小風速の差をとり、それを基準に矢印の長さを決める
    let x2 = x1 + (r2) * cos(direction);    //矢印の終点となるべき点
    let y2 = y1 + (r2) * sin(direction);
    x[i] += (x2 - x[i])/10.0;      //矢印を動かす
    y[i] += (y2 - y[i])/10.0;
    strokeWeight(fuusoku[i]-minFuusoku);
    line(x1, y1, x[i], y[i]);      //矢印の線の描画
    //以下、矢印の矢じりの部分
    let arrowAngle1 = direction + PI + PI/4;
    let arrowAngle2 = direction + PI - PI/4;
    let l = 6;
    let arrowX1 = x[i] + l * cos(arrowAngle1);
    let arrowY1 = y[i] + l * sin(arrowAngle1);
    let arrowX2 = x[i] + l * cos(arrowAngle2);
    let arrowY2 = y[i] + l * sin(arrowAngle2);
    line(x[i], y[i], arrowX1, arrowY1);
    line(x[i], y[i], arrowX2, arrowY2);
  }

  //経過時間が1000ミリ秒を超えたら、矢印の長さを0に戻し、動きをループさせる
  if (passedTime > 1000) {
    for (let i = 0; i < fuukou.length; i++) {
      let angle = PI * 2 / 24 * i - PI/2;
      x[i] = ctX + r * cos(angle);
      y[i] = ctY + r * sin(angle);
      passedTime = 0;
    }
  }
  lastTime = curTime;  //現在の時間を、次フレームの「1フレーム前の時間」としてとっておく
}
