//2018/06/29 東京の毎時気温データ
let kion = [
  25.7, 25.5, 25.5, 25.7, 25.6, 25.8, 28.0, 28.4, 29.7, 30.3, 31.3, 31.6, 31.8, 32.2, 31.7, 30.6, 30.2, 28.6, 27.8, 27.1, 26.7, 26.3, 25.9, 25.9
];
//2017/06/29 東京の毎時気温データ
let kion2017 = [
  20.1, 20.1, 20.5, 20.8, 21.3, 22.0, 23.3, 24.5, 24.9, 25.9, 26.2, 27.1, 27.5, 28.5, 28.4, 28.1, 27.5, 27.5, 25.4, 25.0, 24.5, 24.1, 23.8, 23.6
];
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）

let x = new Array(kion.length);          //2018年のグラフで、毎時のデータを表す点の座標
let y = new Array(kion.length);
let xx = new Array(kion2017.length);     //2017年のグラフで、毎時のデータを表す点の座標
let yy = new Array(kion2017.length);
let r = 200;  //グラフの半径（2018/2017共通）

let ctX;      //2018年のグラフの中心座標
let ctY;
let ctX2;      //2017年のグラフの中心座標
let ctY2;

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/4;
  ctY = height/2;
  ctX2 = width/4 * 3;
  ctY2 = height/2;

  //毎時の基準点となる円周上の点を算出する（2018）
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / kion.length * i - PI/2;
    x[i] = ctX + r * cos(angle);
    y[i] = ctY + r * sin(angle);
  }
  //同（2017）
  for (let i = 0; i < kion2017.length; i++) {
    let angle = PI * 2 / kion2017.length * i - PI/2;
    xx[i] = ctX2 + r * cos(angle);
    yy[i] = ctY2 + r * sin(angle);
  }
}

function draw() {
  background(0);


  //2018年のグラフの描画
  stroke(255);
  strokeCap(SQUARE);
  noFill();
  strokeWeight(5);
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;      //その時間の角度
    let x1 = ctX + r * cos(angle);           //その時間の基準点の座標
    let y1 = ctY + r * sin(angle);
    let r2 = 10  * (kion[i] - heinenchi);    //その時間の気温と平年値との差から、基準点からの距離を算出する
    let x2 = ctX + (r + r2) * cos(angle);    //その時間のデータを示す点の座標
    let y2 = ctY + (r + r2) * sin(angle);
    x[i] += (x2 - x[i]) / 20.0;                //グラフを動かす
    y[i] += (y2 - y[i]) / 20.0;
    if (r2 > 0) {       //平年値より高ければ赤で
      stroke(255, 0, 0, 200);
    } else {            //平年値より低ければ青で
      stroke(0, 0, 255, 200);
    }
    line(x1, y1, x[i], y[i]);    //棒グラフの描画
  }

  //「○時」の描画（2018）
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX + (r-15) * cos(angle);
    let y1 = ctY + (r-15) * sin(angle);
    text(i, x1, y1);
  }

  text("2018年6月29日", width/4, height-50);


  //2017年のグラフの描画
  stroke(255);
  noFill();
  strokeWeight(5);
  for (let i = 0; i < kion2017.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;       //その時間の角度
    let x1 = ctX2 + r * cos(angle);           //その時間の基準点の座標
    let y1 = ctY2 + r * sin(angle);
    let r2 = 10  * (kion2017[i] - heinenchi);    //その時間の気温と平年値との差から、基準点からの距離を算出する
    let x2 = ctX2 + (r + r2) * cos(angle);       //その時間のデータを示す点の座標
    let y2 = ctY2 + (r + r2) * sin(angle);
    xx[i] += (x2 - xx[i]) / 20.0;               //グラフを動かす
    yy[i] += (y2 - yy[i]) / 20.0;
    if (r2 > 0) {       //平年値より高ければ赤で
      stroke(255, 0, 0, 200);
    } else {            //平年値より低ければ青で
      stroke(0, 0, 255, 200);
    }
    line(x1, y1, xx[i], yy[i]);    //棒グラフの描画
  }

  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  //「○時」の描画（2017）
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX2 + (r-15) * cos(angle);
    let y1 = ctY2 + (r-15) * sin(angle);
    text(i, x1, y1);
  }

  text("2017年6月29日", width/4*3, height-50);
}
