let r1 = 300.0;  //円Aの半径
let r2 = 200.0;  //円Bの半径
let angle1 = new Array(20);  //円Aの各点の持っている角度を入れる配列
let angle2 = new Array(angle1.length);  //円Bの各点の持っている角度を入れる配列（円Aの点の数を同じだけ）
let x1 = new Array(angle1.length);    //円Aの各点の持っている座標
let y1 = new Array(angle1.length);
let x2 = new Array(angle2.length);    //円Bの各点の持っている座標
let y2 = new Array(angle2.length);


function setup() {
  createCanvas(windowWidth, windowHeight);
  for (let i = 0; i < angle1.length; i++) {
    angle1[i] = PI*2/angle1.length*i;  //360（2π）を点の数で割って、自分の番号をかける
    angle2[i] = PI*2/angle2.length*i;
  }
}
function draw() {
  background(0);

  //座標の計算==========================================================================
  noStroke();
  fill(0, 50, 255);
  for (let i = 0; i < angle1.length; i++) {
    x1[i] = width/2 + (r1) * cos(angle1[i]);  //自分の持っている角度からx座標を計算する（円A）
    y1[i] = height/2 + (r1) * sin(angle1[i]);  //自分の持っている角度からy座標を計算する（円A）
    x2[i] = width/2 + (r2) * cos(angle2[i]);  //自分の持っている角度からx座標を計算する（円B）
    y2[i] = height/2 + (r2) * sin(angle2[i]);  //自分の持っている角度からy座標を計算する（円B）
  }

  //描画==============================================================================
  stroke(255);
  noFill();
  for (let i = 0; i < angle1.length; i++) {
    line(x1[i], y1[i], x2[i], y2[i]);  //円A上の点から円B上の点に直線を引く
  }
  noStroke();
  fill(0, 100, 255);
  for (let i = 0; i < angle1.length; i++) {
    ellipse(x1[i], y1[i], 10, 10);  //円A上の点を描画
    ellipse(x2[i], y2[i], 10, 10);  //円B上の点を描画
    angle1[i] += 0.02;  //回転させるために角度を増やす
    angle2[i] += 0.025;  //回転させるために角度を増やす
  }
}
