let x1 = new Array(30);                    //1番目の円周上の点のx座標群
let y1 = new Array(x1.length);             //1番目の円周上の点のy座標群
let x2 = new Array(x1.length);             //2番目の円周上の点のx座標群
let y2 = new Array(x1.length);             //2番目の円周上の点のy座標群
let x3 = new Array(x1.length);             //3番目の円周上の点のx座標群
let y3 = new Array(x1.length);             //1番目の円周上の点のy座標群
let iAngle1 = new Array(x1.length);    //1番目の円周上の点の目標角度
let iAngle2 = new Array(x1.length);    //2番目の円周上の点の目標角度
let iAngle3 = new Array(x1.length);    //3番目の円周上の点の目標角度
let angle1 = new Array(x1.length);     //1番目の円周上の点の角度
let angle2 = new Array(x1.length);     //2番目の円周上の点の角度
let angle3 = new Array(x1.length);     //3番目の円周上の点の角度
let ct;           //円の中心の座標
let r1 = 100;       //1番目の円の半径
let r2 = 300;       //2番目の円の半径
let r3 = 700;       //3番目の円の半径

function setup() {
  createCanvas(windowWidth, windowHeight);

  //円の中心座標を画面の中心に
  ct = createVector(width/2, height/2);

  //1番目の円周上の点の座標、角度を初期化
  for (let i = 0; i < x1.length; i++) {
    angle1[i] = PI * 2 / x1.length * i;
    iAngle1[i] = angle1[i];
    x1[i] = int(ct.x + r1 * cos(angle1[i]));
    y1[i] = int(ct.y + r1 * sin(angle1[i]));
  }
  //2番目の円周上の点の座標、角度を初期化
  for (let i = 0; i < x1.length; i++) {
    angle2[i] = PI * 2 / x1.length * i + 0.3;
    iAngle2[i] = angle2[i];
    x2[i] = int(ct.x + r2 * cos(angle2[i]));
    y2[i] = int(ct.y + r2 * sin(angle2[i]));
  }
  //3番目の円周上の点の座標、角度を初期化
  for (let i = 0; i < x1.length; i++) {
    angle3[i] = PI * 2 / x1.length * i -0.3;
    iAngle3[i] = angle3[i];
    x3[i] = int(ct.x + r3 * cos(angle3[i]));
    y3[i] = int(ct.y + r3 * sin(angle3[i]));
  }
}

function draw() {
  background(0);

  //それぞれの点の座標、角度の計算
  for (let i = 0; i < x1.length; i++) {
    iAngle1[i] = PI * 2 / x1.length * i - ((width/2 - mouseX) / width) * 1.2;
    iAngle2[i] = PI * 2 / x1.length * i + ((width/2 - mouseX) / width) * 1.2;
    iAngle3[i] = PI * 2 / x1.length * i - ((width/2 - mouseX) / width) * 1.2;
    angle1[i] += (iAngle1[i] - angle1[i]) / 10.0;
    angle2[i] += (iAngle2[i] - angle2[i]) / 10.0;
    angle3[i] += (iAngle3[i] - angle3[i]) / 10.0;
    x1[i] = int(ct.x + r1 * cos(angle1[i]));
    y1[i] = int(ct.y + r1 * sin(angle1[i]));
    x2[i] = int(ct.x + r2 * cos(angle2[i]));
    y2[i] = int(ct.y + r2 * sin(angle2[i]));
    x3[i] = int(ct.x + r3 * cos(angle3[i]));
    y3[i] = int(ct.y + r3 * sin(angle3[i]));
  }

  //それぞれの点を結んで色面を描く
  noStroke();
  strokeWeight(0.0);
  colorMode(HSB);
  let c;
  for (let i = 0; i < x1.length; i++) {
    c = 255.0 / x1.length * i;   //点の番号に比例した色相をつける
    fill(c, 255, 255);
    if (i != x1.length-1) {      //最後の点以外は、それぞれの円のi番目の点どうしと、i+1番目の点どうしを結ぶ
      beginShape();
      vertex(ct.x, ct.y);
      vertex(x1[i], y1[i]);
      vertex(x2[i], y2[i]);
      vertex(x3[i], y3[i]);
      vertex(x3[i+1], y3[i+1]);
      vertex(x2[i+1], y2[i+1]);
      vertex(x1[i+1], y1[i+1]);
      vertex(ct.x, ct.y);
      endShape();
    } else {                      //最後の外は、それぞれの円のi番目の点どうしと、最初の番号の点どうしを結ぶ
      beginShape();
      vertex(ct.x, ct.y);
      vertex(x1[i], y1[i]);
      vertex(x2[i], y2[i]);
      vertex(x3[i], y3[i]);
      vertex(x3[0], y3[0]);
      vertex(x2[0], y2[0]);
      vertex(x1[0], y1[0]);
      vertex(ct.x, ct.y);
      endShape();
    }
  }
}
