let x = new Array(100);        //波紋の中心x座標
let y = new Array(x.length);   //波紋の中心y座標
let r = new Array(x.length);   //波紋の半径
let a = new Array(x.length);   //波紋のアルファ値
let s = new Array(x.length);   //波紋の大きくなるスピード
let num = 0;                       //現在の波紋の番号

function setup() {
  createCanvas(windowWidth, windowHeight);
  //波紋の各要素の初期化
  for (let i = 0; i < r.length; i++) {
    x[i] = 0;
    y[i] = 0;
    r[i] = 9999;
    a[i] = 0;
    s[i] = 0;
  }
}

function draw() {
  background(0);

  //マウスが動いていたら新しい波紋を描く
  if (pmouseX != mouseX || pmouseY != mouseY) {      //1フレーム前と現在のマウスの座標が違ったら
    x[num] = mouseX;    //新しい波紋の座標をマウスの位置に
    y[num] = mouseY;
    r[num] = 0;         //波紋の半径を0に
    a[num] = 255;       //波紋のアルファを255にして見えるように
    s[num] = dist(mouseX, mouseY, pmouseX, pmouseY) / 20;      //波紋のスピードを1フレーム前からのマウスの移動距離に比例させる
    if (s[num] > 5.0) s[num] = 5.0;    //スピードが大きくなりすぎるのを制限する
    num ++;             //最新の波紋の番号を1増やす
    if (num > x.length - 1) {
      num = 0;
    }
  }

  //波紋の描画
  noFill();
  for (let i = 0; i < x.length; i++) {
    if (a[i] > 0) {       //アルファが0以上なら描画する
      stroke(255, a[i]);  //アルファ値を使って線の色を設定する
      ellipse(x[i], y[i], r[i], r[i]);      //x, y, 半径を使って円を描く
      r[i] += s[i];       //半径を大きくする
      a[i] -= 3;          //アルファを下げて薄くする
    }
  }
}
