let marus = new Array(10);    //Maruのインスタンスを入れる配列
let me = new Me();        //自機を初期化
let isStarted = false;    //ゲームが開始したかどうか
let isDead = false;       //ゲームオーバーしたかどうか
let passedTime = 0;       //合計経過時間
let lastTime = 0;        //1フレーム前の時間
let totalTime = 0;    //合計経過時間（passedTimeは途中でリセットされてしまうので）
function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  me.x = width/2;
  me.y = height/2;
  for(let i = 0; i < marus.length; i++){
    marus[i] = new Maru();
    marus[i].x = random(width);
    marus[i].y = random(height);
    marus[i].addX = random(-6, 6);
    marus[i].addY = random(-6, 6);
    marus[i].r = 50;
    marus[i].ir = marus[i].r;
    marus[i].hueColor = random(360);
  }
  lastTime = millis();
}

function draw(){
  background(0);
  //時間関係の処理
  let curTime = millis();
  if(isStarted == true && isDead != true){
    passedTime += curTime - lastTime;
    totalTime += curTime - lastTime;
    //5秒を超えたら丸を大きくして、加速する
    if(passedTime > 5000){
      for(let i = 0; i < marus.length; i++){
        marus[i].ir += 5;
        marus[i].addX *= 1.1;
        marus[i].addY *= 1.1;
      }
      passedTime = 0;   //時間をリセット
    }
    textAlign(LEFT, BASELINE);
    fill(255);
    noStroke();
    textSize(18);
    text(int(passedTime), 50, 50);
  }
  //丸の位置計算と描画
  for(let i = 0; i < marus.length; i++){
    if(isStarted == true){
      marus[i].update();    //丸に位置計算の命令を出す
      //丸の中心とmeの距離が、丸の半径よりも小さければ、isDeadをtrueにして終わる
      if(dist(marus[i].x, marus[i].y, me.x, me.y) < marus[i].r){
        isDead = true;
      }
    }
    marus[i].drawMaru();    //丸に描画の命令を出す
  }
  //ゲーム開始していたらmeの位置計算を行う。それ以外は説明の矢印を出させる。
  if(isStarted == true){
    me.update();
  }else{
    me.drawSetsumei();
  }
  //meの描画
  me.drawMe();
  //ゲーム開始前だったら半透明の四角を画面にかぶせ、説明文を出す
  if(isStarted != true){
    colorMode(RGB);
    noStroke();
    fill(255, 100);
    rect(0, 0, width, height);
    fill(255);
    textAlign(CENTER, CENTER);
    text("どれかキーを押すとスタートします", width/2, height - 100);
    text("矢印キーで操作してください", width/2, height -78);
  }
  //死んでいたら画面を赤く塗る
  if(isDead == true){
    colorMode(RGB);
    noStroke();
    fill(255, 0, 0, 100);
    rect(0, 0, width, height);
    fill(255, 255, 0);
    noStroke();
    textSize(48);
    textFont("HelveticaNeue");
    textAlign(CENTER, CENTER);
    text("SCORE\n" + nfc(totalTime/1000, 2) + " sec", width/2, height/2);
  }
  lastTime = curTime; //このフレームの時間を取っておく
}
//キー操作
function keyPressed(){
  //ゲーム開始していたら、矢印キーでmeに速度を加える。まだ開始していなければ開始させる
  if(isStarted == true){
    if(isDead != true){
      let speed = 5.0;
      if(keyCode == LEFT_ARROW){
        me.addX -= speed;
      }else if(keyCode == RIGHT_ARROW){
        me.addX += speed;
      }else if(keyCode == UP_ARROW){
        me.addY -= speed;
      }else if(keyCode == DOWN_ARROW){
        me.addY += speed;
      }
    }
  }else{
    isStarted = true;   //ゲーム開始
  }
  return false;
}
