/* 時間を数えるサンプル */
let passedTime = 0;   //経過時間
let lastTime = 0;   //1フレーム前の時間

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  lastTime = millis();    //起動時の時間をとっておく
}

function draw(){
  background(0);
  let curTime = millis();     //現在の時間をミリ秒で取得
  passedTime += (curTime - lastTime);     //「現在の時間」と「1フレーム前の時間」の差を取り、「経過時間」に加える

  //5秒経ったら背景を赤に変える
  if(passedTime > 5000){
    background(255, 0, 0);
  }

  //経過時間を文字で表示
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  textSize(100);
  text(int(passedTime), width/2, height/2);

  lastTime = curTime;        //このフレームの時間を取っておく。
}

function mousePressed(){
  //マウスが押されたら時間をリセット
  passedTime = 0;
}
