/* 点群をマトリクス状に並べる */
let yokoNum = 50;     //横に並べる点の個数
let tateNum = 50;     //縦に並べる点の個数
let x = new Array(yokoNum * tateNum);   //横×縦の数の座標配列を作る
let y = new Array(x.length);
let marginX = 20;     //点と点の間の間隔（x）
let marginY = 20;     //点と点の間の間隔（y）
let shikiso = new Array(x.length);    //1つ1つの点の色相を入れておくための配列
let meido = new Array(x.length);      //1つ1つの点の明度を入れておくための配列
let r = new Array(x.length);    //1つ1つの点の直径

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  //並べる点の数と、点どうしの間隔から、全体の幅・高さを計算する
  let haba = (yokoNum - 1) * marginX;   //全体の幅
  let takasa = (tateNum - 1) * marginY;   //全体の高さ
  //全体の幅・高さを使い、画面の中心を基準として、上端と左端の座標を求める
  let leftX = width/2 - haba / 2;  //左端のx座標
  let topY = height/2 - takasa / 2;  //上端のy座標
  //配列x, yの値を順番に入れていく。一番左上の点から右方向に順番に並べていき、横に並べる個数まできたらまた一番左に戻し、
  let yoko = 0;   //今、横方向に何個並べたか
  let tate = 0;   //今、縦方向に何個並べたか
  for(let i = 0; i < x.length; i++){
    x[i] = leftX + yoko * marginX;    //左端の座標＋横方向の個数×間隔
    y[i] = topY + tate * marginY;    //上端の座標＋縦方向の個数×間隔
    yoko = yoko + 1;    //横方向の個数に+1する
    //横に並べたい個数まで来たら、yokoを0にし、tateを+1する（改行される）。
    if(yoko >= yokoNum){
      yoko = 0;
      tate = tate + 1;
    }
    shikiso[i] = 360 / yokoNum * yoko;
    meido[i] = 100 - 100 / tateNum * tate;
    r[i] = 10.0;
  }
}

function draw(){
  colorMode(HSB);
  noCursor();   //マウスカーソルを隠す関数
  background(0);
  for(let i = 0; i < x.length; i++){
    fill(shikiso[i], 100, meido[i]);   //色を設定
    noStroke();
    circle(x[i], y[i], r[i]);
  }
}
