/* 動きの量の違う点群 */
let yokoNum;     //横に並べる点の個数
let tateNum;     //縦に並べる点の個数
let x;   //点のx座標（あとで配列として宣言）
let y;   //点のy座標
let ox;   //xのホームポジション
let oy;   //yのホームポジション
let addX;   //xの変化量
let addY;   //yの変化量
let marginX = 20;     //点と点の間の間隔（x）
let marginY = 20;     //点と点の間の間隔（y）
let passedTime = 0;   //経過時間
let lastTime = 0;     //1フレーム前の時間

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  let yokoNum = ceil(width / marginX);
  let tateNum = ceil(height / marginY);
  let num = ceil(yokoNum * tateNum);
  x = new Array(num);
  y = new Array(x.length);
  ox = new Array(x.length);
  oy = new Array(x.length);
  addX = new Array(x.length);
  addY = new Array(x.length);
  //並べる点の数と、点どうしの間隔から、全体の幅・高さを計算する
  let haba = (yokoNum - 1) * marginX;   //全体の幅
  let takasa = (tateNum - 1) * marginY;   //全体の高さ
  //全体の幅・高さを使い、画面の中心を基準として、上端と左端の座標を求める
  let leftX = width/2 - haba / 2;  //左端のx座標
  let topY = height/2 - takasa / 2;  //上端のy座標
  //配列x, yの値を順番に入れていく。一番左上の点から右方向に順番に並べていき、横に並べる個数まできたらまた一番左に戻し、
  let yoko = 0;   //今、横方向に何個並べたか
  let tate = 0;   //今、縦方向に何個並べたか
  for(let i = 0; i < x.length; i++){
    x[i] = leftX + yoko * marginX;    //左端の座標＋横方向の個数×間隔
    y[i] = topY + tate * marginY;    //上端の座標＋縦方向の個数×間隔
    ox[i] = x[i];
    oy[i] = y[i];
    yoko = yoko + 1;    //横方向の個数に+1する
    let kyori = dist(x[i], y[i], width/2, height/2);
    let kakudo = atan2(y[i] - height/2, x[i] - width/2);
    if(y[i] > height/2){
      addX[i] = kyori * cos(kakudo) / 400.0;
      addY[i] = kyori * sin(kakudo) / 400.0;
    }else{
      addX[i] = 0;
      addY[i] = 0;
    }
    //横に並べたい個数まで来たら、yokoを0にし、tateを+1する（改行される）。
    if(yoko >= yokoNum){
      yoko = 0;
      tate = tate + 1;
    }
  }
}

function draw(){
//  colorMode(HSB);
  let curTime = millis(); //現在の経過時間を取得（単位：ミリ秒）
  passedTime += curTime - lastTime;
  if(passedTime > 1000){
    for(let i = 0; i < x.length; i++){
      x[i] = ox[i];
      y[i] = oy[i];
    }
    passedTime = 0;
  }
//  noCursor();   //マウスカーソルを隠す関数
  background(0);
  for(let i = 0; i < x.length; i++){
    let kyori = dist(mouseX, mouseY, x[i], y[i]);   //マウスと点との距離を測る
    if(kyori > 100){
      x[i] = x[i] + addX[i];
      y[i] = y[i] + addY[i];
    }
    noFill();
    stroke(255);
    line(x[i], y[i], ox[i], oy[i]);
  }
  lastTime = curTime;
}
