/* 押されたキーの位置から、キーの文字を表示するサンプル */

//表示される文字群の座標、フォントサイズ、文字、アルファを配列として作っておく
let x = new Array(50);    //長さを50個にする（＝最大で表示される文字の数）
let y = new Array(x.length);
let fSize = new Array(x.length);    //フォントサイズ
let addFSize = new Array(x.length); //毎フレームfSizeに加える変数
let st = new Array(x.length);       //文字
let alphas = new Array(x.length);   //アルファ
//上の配列の中で、今何番目の文字を表示しているか
let curNum = 0;
//キーボードのキーの配置を入れた配列（二重配列）
let keys = [
  ['1','2','3','4','5','6','7','8','9','0','-','^','¥'],
  ['q','w','e','r','t','y','u','i','o','p','@','['],
  ['a','s','d','f','g','h','j','k','l',';',':',']'],
  ['z','x','c','v','b','n','m',',','.','/','_']
];

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  //x,y等の初期化
  for(let i = 0; i < x.length; i++){
    x[i] = -100;
    y[i] = -100;
    fSize[i] = 1;
    addFSize[i] = 0;
    st[i] = '';
    alphas[i] = 0;
  }
}
function draw(){
  background(0);
  textFont("'Univers Next Pro', 'Univers LT Std', Helvetica, HelveticaNeue, sans-serif");
  for(let i = 0; i < x.length; i++){
    fill(255, alphas[i]);
    noStroke();
    textAlign(CENTER, CENTER);
    textSize(fSize[i]);
    text(st[i], x[i], y[i]);
    fSize[i] += addFSize[i];
    alphas[i] -= 1;
  }
}
function keyPressed(){
  for(let i = 0; i < keys.length; i++){
    let row = keys[i];
    for(let j = 0; j < row.length; j++){
      //キーが見つかればcurNumを+1し、x[curNum]等を設定する
      if(row[j] == key){
        curNum += 1;    //curNumを1増やす
        //もしxの配列の長さより大きくなってしまったら0に戻す
        if(curNum > x.length-1){
          curNum = 0;
        }
        //行番号、列番号に応じた(x,y)の設定
        x[curNum] = (width-200) / (keys[i].length-1) * j + 100;
        y[curNum] = (height-200) / (keys.length-1) * i + 100;
        fSize[curNum] = 1;    //フォントサイズを1に戻す
        addFSize[curNum] = 5;
        st[curNum] = key;     //タイプされたキーをstに入れる
        alphas[curNum] = 255;   //アルファを255にして表示されるようにする
      }
    }
  }
}
function keyReleased(){

}
