/* マウスと円 */
//1つめの円の中心座標
let x = 0;
let y = 0;
let ix = 0;   //目標値
let iy = 0;   //目標値
//2つめの円の中心座標
let xx = 0;
let yy = 0;
//3つめの円の中心座標
let xxx = 0;
let yyy = 0;
//円の半径（3つ共通）
let r = 150;
//ドラッグ中かどうか
let oshiteru = false;
function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  //3つの円の座標を画面の中心に
  x = width/2;
  y = height/2;
  ix = x;
  iy = y;
  xx = x;
  yy = y;
  xxx = x;
  yyy = y;
}

function draw(){
  clear();
  background(0);
  blendMode(ADD);   //ブレンドモードを「加算」に
  //1つめの円は(ix, iy)に近く
  x = x + (ix - x) / 20.0;
  y = y + (iy - y) / 20.0;
  //2つめの円は1つめの円の座標(x,y)に近く
  xx = xx + (x - xx) / 20.0;
  yy = yy + (y - yy) / 20.0;
  //3つめの円は2つめの円の座標(xx,yy)に近く
  xxx = xxx + (xx - xxx) / 20.0;
  yyy = yyy + (yy - yyy) / 20.0;

  let kyori = dist(x, y, mouseX, mouseY);   //1つめの円の中心座標とマウスとの距離を測る
  //3つめの円を描く
  noFill();
  stroke(0, 0, 255);
  //マウスオーバーしているかドラッグ中なら色を変える
  if(kyori < r || oshiteru == true){
    fill(0, 0, 255);
  }
  circle(xxx, yyy, r*2);

  //2つめの円を描く
  noFill();
  stroke(0, 255, 0);
  if(kyori < r || oshiteru == true){
    fill(0, 255, 0);
  }
  circle(xx, yy, r*2);

  //1つめの円を描く
  noFill();
  stroke(255, 0, 0);
  if(kyori < r || oshiteru == true){
    fill(255, 0, 0);
  }
  circle(x, y, r*2);

  //ドラッグ中は(ix, iy)をマウスの座標にする
  if(oshiteru){
    ix = mouseX;
    iy = mouseY;
  }
}
function mousePressed(){
  oshiteru = false;   //一旦oshiteruをfalseにする
  //1つめの円の中心座標とマウスカーソルとの距離を測り、円の半径よりも小さければoshiteruをtrueにする
  let kyori = dist(x, y, mouseX, mouseY);
  if(kyori < r){
    oshiteru = true;
  }
}
function mouseReleased(){
  //マウスが離された時にoshiteruをfalseに戻す
  oshiteru = false;
}
