/* マウスカーソルが四角形の中で押されたかゲーム */
let x = 0;    //四角形の左上の点のx座標
let y = 0;    //四角形の左上の点のy座標
let w = 100;    //四角形の幅
let h = 100;    //四角形の高さ
let ix = x;   //xが向かう座標
let iy = y;   //yが向かう座標
let score = 0;    //スコア
let time = 30;    //残り時間
let byo = 0;      //現在の秒数
let lastByo = byo;    //1フレーム前の秒数

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  //四角形の座標を画面に入る範囲でランダムで決める
  x = random(width - w);
  y = random(height - h);
  ix = x;
  iy = y;
  //アプリ開始時の秒数を取っておく
  byo = second();
  lastByo = byo;
}

function draw(){
  background(0);

  byo = second();   //現在の秒数を取得
  //1フレーム前と現在の秒数を比べて、異なっていればその差を取り、残り時間から減らす
  if(byo != lastByo){
    let sa = byo - lastByo;   //現在の秒数と1フレーム前の秒数の差
    //「59」→「0」になると、秒数差がマイナスになってしまうので、それを調整する
    if(sa < 0){
      sa = sa + 60;
    }
    //残り時間から秒数差を減らす
    time = time - sa;
    //残り時間が0未満にならないようにする
    if(time < 0){
      time = 0;
    }
  }

  if(time <= 0){
    background(255, 0, 0);
  }

  //(x,y)を(ix,iy)にふわっと近づける
  x = x + (ix - x) / 10.0;
  y = y + (iy - y) / 10.0;

  //四角形の描画
  if(time > 0){
    noFill();
    stroke(255, 0, 0);
    //マウスが四角形の上に乗っていれば色を変える
    if(x < mouseX && mouseX < x + w && y < mouseY && mouseY < y + h){
      fill(0, 255, 0);
      noStroke();
    }
    rect(x, y, w, h);     //x,yを中心に、w,hを幅・高さとして四角形を描画
  }

  //スコアの描画
  fill(255);
  noStroke();
  textSize(14);
  textAlign(LEFT);
  text("Score: " + score, 50, 50);

  //残り時間の描画
  fill(255);
  noStroke();
  textSize(14);
  textAlign(RIGHT);
  text("Time: " + time, width - 50, 50);

  lastByo = byo;      //「1フレーム前の秒数」を「現在の秒数」と同期する
}

function mousePressed(){
  if(time > 0){
    //マウスが四角形の上に乗った状態でボタンが押されたら、スコアを+1し、向かうべき座標をランダムに設定する
    if(x < mouseX && mouseX < x + w && y < mouseY && mouseY < y + h){
      ix = random(width - w);
      iy = random(height - h);
      score = score + 1;
    }
  }
}
