/* マウスカーソルが円の中に入ったかどうかの判定 */
let x = 0;    //円の中心のx座標
let y = 0;    //円の中心のy座標
let r = 0;    //円の半径
let insideMaru = false;   //マウスカーソルが円の中に入っていたらtrueにする
function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
}

function draw(){
  x = width/2;    //xを画面の中心に
  y = height/2;    //yを画面の中心に

  //x,yとマウスの座標との距離を取り、それが円の半径rよりも小さければinsideMaruをtrueにする。
  if(dist(x, y, mouseX, mouseY) < r){
    insideMaru = true;
  }else{
    insideMaru = false;
  }

  //insideMaruがtrueかどうかで背景の色を変える
  if(insideMaru == true){
    background(255, 255, 0);
  }else{
    background(0);
  }

  //insideMaruがtrueかどうかで円の色を変える
  if(insideMaru == true){
    fill(0);
  }else{
    fill(255, 255, 0);
  }
  noStroke();
  circle(x, y, r*2, r*2);     //x,yを中心に、rを半径として円を描画

  //rを1増やす
  r = r + 1;

  //半径が画面の対角線の半分よりも大きくなってしまったら0に戻す
  if(r > dist(0, 0, width/2, height/2)){
    r = 0;
  }
}
