/* 画像をピクセル毎に分解する */
let img;	//読み込んだ画像をおさめる変数
let x;		//1つ1つの点のx座標（配列）
let y;		//1つ1つの点のy座標（配列）
let addX;		//砕けちる時の変化量
let addY;		//砕けちる時の変化量
let cols;		//1つ1つの点の色
let isTouched = false;		//マウスが画像にタッチしたらtrueにする→砕けちる
function preload(){
	img = loadImage("./data/monalisa_50w.jpg");		//画像を読み込む
}
function setup(){
	createCanvas(windowWidth, windowHeight);
	img.loadPixels();		//画像のピクセル情報を読み込み
	cols = new Array(img.pixels.length / 4);		//ピクセルの数と同じだけ配列を作る（RGBAがあるので4で割らないといけない）
	//x, y, ox, oy, addX, addYを初期化する
	x = new Array(cols.length);
	y = new Array(cols.length);
	addX = new Array(cols.length);
	addY = new Array(cols.length);
	//ピクセルごとの色を取り出して、colsに保存。また、x,yを画面中心に置き、そこをホームポジションとする
	for(let i = 0; i < img.width; i++){
		for(let j = 0; j < img.height; j++){
			let n = j * img.width + i;		//ピクセルの番号
			let r = img.pixels[n * 4];			//R
			let g = img.pixels[n * 4 + 1];	//G
			let b = img.pixels[n * 4 + 2];	//B
			let a = img.pixels[n * 4 + 3];	//A
			cols[n] = color(r, g, b, a);		//RGBAの値を下にcolsにp5.Colorオブジェクトを代入
			x[n] = width/2 - img.width/2 + i;			//xの座標を画面の中心に
			y[n] = height/2 - img.height/2 + j;		//yの座標を画面の中心に
			//砕け散った時の変化量をランダムで決める
			addX[n] = random(-3, 3);
			addY[n] = random(-3, 3);
		}
	}
}
function draw(){
	background(0);
	for(let i = 0; i < x.length; i++){
		noFill();
		stroke(cols[i]);			//colsで色を指定
		point(x[i], y[i]);
		//マウスが画像に触れたらxにaddXを、yにaddYを加える
		if(isTouched){
			x[i] = x[i] + addX[i];
			y[i] = y[i] + addY[i];
		}
	}
	//マウスが画像の範囲に触れたかどうかの判定
	if(width/2 - img.width/2 <= mouseX && mouseX <= width/2 + img.width/2 && height/2 - img.height/2 <= mouseY && mouseY <= height/2 + img.height/2){
		isTouched = true;
	}
}
