/* 画像の一部だけ描画する */
let img;	//読み込んだ画像をおさめる変数
function preload(){
	img = loadImage("./data/monalisa_large.jpg");
}
function setup(){
	createCanvas(windowWidth, windowHeight);
}
function draw(){
	background(0);

	//元画像を画面左半分に描画--------------------------------------------------
	let drawH = height;								//画像を描画する高さを画面の高さに固定
	let bai = drawH / img.height;			//「描画する高さ÷オリジナルの高さ」で表示倍率を計算
	let drawW = img.width * bai;			//オリジナルの高さに表示倍率を掛けて描画する高さを計算
	let drawX = width / 4 - drawW/2;		//画像を画面左半分に描くための座標計算
	let drawY = height/2 - drawH/2;		//画像を画面左半分に描くための座標計算

	imageMode(CORNER);
	image(img, drawX, drawY, drawW, drawH);		//オリジナル画像を縮小表示

	//元画像から切り取る幅・高さを決め、その枠を表示する--------------------------------------------------
	let sw = 100;			//切り取る枠の幅
	let sh = 100;			//切り取る枠の高さ

	noFill();
	stroke(255, 0, 0);
	rect(mouseX, mouseY, sw * bai, sh * bai);		//切り取る枠を表示

	//マウスと縮小画像の座標の差を求め、表示倍率で割って元画像における位置を計算する--------------------------------------------------
	let sx = (mouseX - drawX) / bai;
	let sy = (mouseY - drawY) / bai;

	//切り取った画像の表示サイズを決める--------------------------------------------------
	let dw = 200;
	let dh = 200;
	//切り取った画像の表示位置を決める--------------------------------------------------
	let dx = width * 0.75 - dw/2;
	let dy = height/2 - dh/2;
	//切り取った画像を描画--------------------------------------------------
	image(img, dx, dy, dw, dh, sx, sy, sw, sh);	//画像の一部を描画
}
