/* マウスの位置に対応した画像の色を取得してみる */
let img;    //画像を入れる変数
let pxls;   //ピクセルの配列
function preload(){
  img = loadImage('./data/monalisa.jpg');
}
function setup(){
  createCanvas(windowWidth, windowHeight);
  img.loadPixels(); //画像のピクセル情報を読み込み
  pxls = img.pixels;    //画像のピクセル情報を配列pxlsに写す。pxlsには1ピクセルごとのRGBA値が順番に入っている。
}
function draw(){
  //バックに画像があるとして、そのサイズと座標を計算する
  let drawH = height;               //画像を描画する高さ=画面の高さに設定する
  let bai = drawH / img.height;     //「描画する高さ÷画像のオリジナルの高さ」で表示倍率を計算する
  let drawW = img.width * bai;      //画像の高さに表示倍率を掛け、描画する幅を計算する
  let drawX = width/2 - drawW/2;       //左上の点のx座標を求める。
  let drawY = height/2 - drawH/2;      //左上の点のy座標を求める。

  //元の画像のどのピクセルをとってくるかを計算する
  let xx = (mouseX - drawX) / bai;    //マウスのx座標と画像の原点との差を求め、それを表示倍率で割って、相対的なx座標を割り出す
  let yy = (mouseY - drawY) / bai;    //マウスのy座標と画像の原点との差を求め、それを表示倍率で割って、相対的なy座標を割り出す

  if(xx >= 0 && xx <= img.width && yy >= 0 && yy <= img.height){
    let n = int(yy) * img.width + int(xx);    //ピクセル番号を求める
    let r = pxls[n * 4];    //Rの値
    let g = pxls[n * 4 + 1];  //Gの値
    let b = pxls[n * 4 + 2];  //Bの値
    let a = pxls[n * 4 + 3];  //Aの値
    noStroke();
    fill(r, g, b, a);   //r, g, b, aの数値を使って描画色を決める
    circle(mouseX, mouseY, 10); //マウスの位置に円を描く
  }
}
