/* 画像の色を取り出し、色相の順番に表示 */
let img;    //画像を入れる変数
let pxls;   //ピクセルの配列

let cols;       //色情報を入れる配列
function preload(){
  img = loadImage('./data/monalisa_1024h.jpg');
}
function setup(){
  createCanvas(windowWidth, windowHeight);
  img.loadPixels();   //画像のピクセル情報を読み込み
  pxls = img.pixels;  //画像のピクセル情報を配列pxlsに写す。pxlsには1ピクセルごとのRGBA値が順番に入っている。
  cols = new Array(pxls.length);
  for(let i = 0; i < img.width; i++){
    for(let j = 0; j < img.height; j++){
      //i, jをもとに画像から色情報を抜き出す
      let n = j * img.width + i;    //何番目のピクセルかを計算する
      let r = pxls[n * 4];          //Rの値を取得
      let g = pxls[n * 4 + 1];      //Gの値を取得
      let b = pxls[n * 4 + 2];      //Bの値を取得
      let a = pxls[n * 4 + 3];      //Aの値を取得
      cols[n] = color(r, g, b, a);
    }
  }
  sortColorsByHue();    //colsを色相の値でソート（独自の関数。下のfunction sortColorsByHue(){...}で定義）

  //元の画像を縮小表示
  let drawH = height;             //画像を描画する高さ=画面の高さに設定する
  let bai = drawH / img.height;   //「描画する高さ÷画像のオリジナルの高さ」で表示倍率を計算する
  let drawW = img.width * bai;    //画像の高さに表示倍率を掛け、描画する幅を計算する
  let drawX = width/4 - drawW/2;    //描画するx座標を決める（画面左半分）。
  let drawY = height/2 - drawH/2;      //描画するx座標を決める（画面左半分）。

  image(img, drawX, drawY, drawW, drawH);   //画像を描画

  //色相の順に並び替えたcolsを使って表示
  for(let i = 0; i < img.width; i++){
    for(let j = 0; j < img.height; j++){
      let n = j * img.width + i;    //何番目のピクセルかを計算する
      stroke(cols[n]);
      noFill();
      point(width/4 * 3 - drawW/2 + i * bai, height/2 - drawH/2 + j * bai);
    }
  }
}
function sortColorsByHue(){
  cols.sort(function(a, b) {
    if(hue(a) == hue(b)){
      if(saturation(a) == saturation(b)){
        if(brightness(a) == brightness(b)){
          return 0;
        }else if(brightness(a) > brightness(b)){
          return 1;
        }else{
          return -1;
        }
      }else if(saturation(a) > saturation(b)){
        return 1;
      }else{
        return -1;
      }
    } else if (hue(a) > hue(b)) {
      return 1;
    } else {
      return -1;
    }
  });
}
