/* 画像の色を順番に表示 */
let img;    //画像を入れる変数
let pxls;   //ピクセルの配列

let x = 0;    //画像から抜き出すピクセルのx位置
let y = 0;    //画像から抜き出すピクセルのy位置
let addX = 10;   //xを毎フレーム変えるための変数（1ピクセルずつだと遅いから...）
function preload(){
  img = loadImage('./data/monalisa.jpg');
}
function setup(){
  createCanvas(windowWidth, windowHeight);
  img.loadPixels();   //画像のピクセル情報を読み込み
  pxls = img.pixels;  //画像のピクセル情報を配列pxlsに写す。pxlsには1ピクセルごとのRGBA値が順番に入っている。
  frameRate(3);       //そのままだと早すぎるのでフレームレートを3フレーム／秒に落とす
}
function draw(){
  background(0);
  let drawH = height;             //画像を描画する高さ=画面の高さに設定する
  let bai = drawH / img.height;   //「描画する高さ÷画像のオリジナルの高さ」で表示倍率を計算する
  let drawW = img.width * bai;    //画像の高さに表示倍率を掛け、描画する幅を計算する
  let drawX = width/4 - drawW/2;    //描画するx座標を決める（画面左半分）。
  let drawY = height/2 - drawH/2;      //描画するx座標を決める（画面左半分）。

  image(img, drawX, drawY, drawW, drawH);   //画像を描画

  //x, yに対応した位置に枠を描く
  noFill();
  stroke(255, 255, 0);
  rect(drawX + x * bai - 5 - 0.5, drawY + y * bai - 5 - 0.5, 10, 10);

  //x, yをもとに画像から色情報を抜き出す
  let n = y * img.width + x;    //何番目のピクセルかを計算する
  let r = pxls[n * 4];          //Rの値を取得
  let g = pxls[n * 4 + 1];      //Gの値を取得
  let b = pxls[n * 4 + 2];      //Bの値を取得
  let a = pxls[n * 4 + 3];      //Aの値を取得
  fill(r, g, b, a);
  noStroke();
  rect(width/2, 0, width/2, height);    //画面右半分を塗りつぶす

  //以下、x, yを動かすための処理
  x = x + addX;
  if(x > img.width-1){
    x = 0;
    y = y + 10; //yに10を足す（1だと遅いから...）
  }
}
