/* マウスの位置に対応した画像の色を取得してみる（画像位置、表示倍率調整なし） */
let img;    //画像を入れる変数
let pxls;   //ピクセルの配列
function preload(){
  img = loadImage('./data/monalisa.jpg');
}
function setup(){
  createCanvas(windowWidth, windowHeight);
  img.loadPixels(); //画像のピクセル情報を読み込み
  pxls = img.pixels;    //画像のピクセル情報を配列pxlsに写す。pxlsには1ピクセルごとのRGBA値が順番に入っている。
}
function draw(){
  //元の画像のどのピクセルをとってくるかを計算する
  let xx = mouseX;    //マウスのx座標と画像の原点との差を求める
  let yy = mouseY;    //マウスのy座標と画像の原点との差を求める

  //xx, yyが画像の幅、高さの範囲内ならそのピクセルの色を取得する
  if(xx >= 0 && xx <= img.width && yy >= 0 && yy <= img.height){
    let n = int(yy) * img.width + int(xx);    //ピクセル番号を求める
    let r = pxls[n * 4];    //Rの値
    let g = pxls[n * 4 + 1];  //Gの値
    let b = pxls[n * 4 + 2];  //Bの値
    let a = pxls[n * 4 + 3];  //Aの値
    noStroke();
    fill(r, g, b, a);   //r, g, b, aの数値を使って描画色を決める
    circle(mouseX, mouseY, 10); //マウスの位置に円を描く
  }
}
