/* webカメラの映像を順番に静止画として描画 */
let x = 0;
let y = 0;
let w = 80;   //描画の幅
let h = 0;    //描画の高さ（あとで変更）
let capture;    //ビデオキャプチャ
function setup(){
  createCanvas(windowWidth, windowHeight);
  capture = createCapture(VIDEO);   //キャプチャ開始(webカメラからの画像がcaptureオブジェクトに入る)
  capture.hide();                   //キャプチャ画面を表示しないようにする
}
function draw(){
  if(capture.loadedmetadata){                       //ブラウザのセキュリティ対策で必要なif文
    h = w / capture.width * capture.height;         //Webカメラの画像比率に応じて描画する高さを計算する
    image(capture, x, y, w, h);                    //取得したキャプチャを画面上に描く
    x += w;   //画像1枚分だけx座標を横にずらす
    //画面右端まで行ったら左端に戻し、改行する
    if(x > width){
      x = 0;
      y += h;
    }
    //画面下端まで行ったら画面左上に戻す
    if(y > height){
      y = 0;
      x = 0;
    }
  }
}
