//サインカーブを使った大小の繰り返し
let kakudo = 0;   //サインカーブを得るために使う角度
function setup(){
  createCanvas(windowWidth, windowHeight);
}
function draw(){
  colorMode(RGB);
  background(0, 30);
  colorMode(HSB);
  textAlign(CENTER, CENTER);
  noFill();
  stroke(kakudo % 360, 100, 100);
  let rad = radians(kakudo);  //度数法（0〜360°）→弧度法（0〜2π）への変換
  let d = 300 + 300 * sin(rad);   //直径の計算。sin(rad)でサイン値（-1〜1）が求められる
  circle(width/2, height/2, d);
  kakudo = kakudo + 1;  //角度を1増やす

  //以下、サイン値を文字として描画するための処理
  fill(0);
  noStroke();
  rect(0, 0, 100, 100);
  textAlign(LEFT, BASELINE);
  fill(255);
  text("sine:", 20, 40);
  text(nfc(sin(radians(kakudo)), 4), 20, 60);
}
