/* 3つの動き（等速直線運動、ふわっと動く、サインカーブ） */
let x = 0;    //一定の速さで動かす円のx座標　
let y = 0;    //一定の速さで動かす円のy座標
let addX = 2;   //毎フレームxに加える値
let addY = 3;   //毎フレームyに加える値

let xx = 0;   //ふわっと動かす円のx座標
let yy = 0;   //ふわっと動かす円のy座標

let xxx = 0;    //サインカーブを使った動きをする円のx座標
let yAngle = 0;     //サインカーブを使った動きをする円のy座標に使う、元の角度

let isPressed = false;  //マウスを押しているかどうか

function setup() {
  createCanvas(windowWidth, windowHeight);
}
function draw(){
  if(isPressed){
    background(0, 30);
  }

  /* 一定の速さの動き */
  x = x + addX;   //xにaddXを足す
  y = y + addY;   //yにaddYを足す
  stroke(0, 255, 0);
  noFill();
  circle(x, y, 30);

  /* ふわっとついてくる動き */
  xx = xx + (mouseX - xx) / 10.0;   //xxをmouseXに近づける
  yy = yy + (mouseY - yy) / 10.0;   //yyをmouseYに近づける
  stroke(255, 0, 0);
  circle(xx, yy, 50);

  /* サインカーブを使った動き */
  xxx = xxx + 2;    //xxxは一定の速さで動く
  yAngle += 1;      //y座標に使う角度
  stroke(0, 0, 255);
  noFill();
  let rad = radians(yAngle);    //度数法→弧度法への変換
  circle(xxx, height/2 + 200 * sin(rad), 100);

  //以下、はねかえりの制御------------------------------------------------

  //xが画面の左右端のどちらかにぶつかったらaddXに-1を掛け、動く方向を反対にする
  if(x > width || x < 0){
    addX = addX * -1;
  }
  //yが画面の上下端のどちらかにぶつかったらaddYに-1を掛け、動く方向を反対にする
  if(y > height || y < 0){
    addY = addY * -1;
  }

  //xxxが画面右端を超えてしまったらxxxを0（左端の座標）に戻す
  if(xxx > width){
    xxx = 0;
  }
}

function mousePressed(){
  isPressed = true;
}
function mouseReleased(){
  isPressed = false;
}
