/* 絵を描く */

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  background(0, 0, 0);  //背景色を指定して1回だけ塗る。

  stroke(0, 0, 255);  //図形の線の色をRGBで指定
  line(100, 200, 500, 400); //直線の支点・終点のx,y座標

  noStroke();   //図形の線を「なし」にする
  fill(255, 0, 0, 150);  //RGBAで塗りの色を指定
  circle(400, 300, 200);  //円の中心のx,y座標と直径

  fill(0, 255, 0);  //塗りの色
  rect(100, 450, 200, 100); //四角形の左上の点の座標と幅、高さ

  noFill(); //塗りの色を「なし」にする
  stroke(0, 255, 255);  //線の色
  triangle(100, 400, 600, 600, 700, 200); //三角形の3つの頂点

  stroke(255, 0, 0);
  bezier(100, 400, 200, 100, 400, 700, 600, 400); //ベジェ曲線

  arc(400, 100, 200, 200, 0, PI*2/3); //中心、幅、高さ、開始角度、終了角度

  ellipse(300, 500, 100, 300);  //楕円。中心、幅、高さ

  stroke(0, 255, 0);
  //多角形を描く
  beginShape();
  vertex(100, 200);
  vertex(200, 300);
  vertex(150, 400);
  vertex(100, 350);
  vertex(50, 250);
  endShape(CLOSE);
}

function draw(){
//  circle(mouseX, mouseY, 100);
  point(mouseX, mouseY);  //点を打つ

}
