/* 二重ループを使って円を円環マトリクス状に並べる */
let retsuNum = 20;  //並べたい列数
let gyoNum = 10;    //並べたい行数
let x = new Array(retsuNum * gyoNum);   //x座標。並べたい列数×行数のぶんだけ配列を作る
let y = new Array(x.length);    //y座標
let r = new Array(x.length);    //現在の半径
let shikiso = new Array(x.length);   //色相
let saido = new Array(x.length);   //彩度

function setup(){
  createCanvas(windowWidth, windowHeight);
  let cx = width/2;   //円環の中心のx座標
  let cy = height/2;  //円環の中心のy座標
  //二重の繰り返しを作る。列数ぶんの繰り返しの中に行数分の繰り返し。合計して列数×行数の繰り返しとなるので、同じ長さのx, yの配列全てに処理が行き渡る
  for(let i = 0; i < retsuNum; i = i + 1){  //列数ぶんだけ繰り返し。iが現在の列番号を示す
    for(let j = 0; j < gyoNum; j = j + 1){  //行数ぶんだけ繰り返し。jが現在の行番号を示す
      let index = i + j * retsuNum;       //現在の列番号、行番号から配列のインデックスを割り出す
      let kakudo = PI * 2 / retsuNum * i;   //円の一周＝2Πを列数で割り、1列あたりの角度を求める。それに現在の行番号をかけて、角度を求める
      let hankei = j * 40;      //現在行数に応じて円環状の半径を求める
      x[index] = cx + hankei * cos(kakudo);   //三角関数でx座標を求める
      y[index] = cy + hankei * sin(kakudo);   //三角関数でx座標を求める
      r[index] = 0.0;     //円の半径を最初は0にしておく
      shikiso[index] = 255 / retsuNum * i;   //色相の計算(最大値255を列数で割り、現在の列番号をかける)
      saido[index] = 255 / gyoNum * j;     //彩度の計算（最大値255を行数で割り、現在の行番号をかける）
    }
  }
}
function draw(){
  background(0);
  noStroke();
  colorMode(HSB);
  //二重の繰り返しを作る（行数×列数）
  for(let i = 0; i < retsuNum; i = i + 1){
    for(let j = 0; j < gyoNum; j = j + 1){
      let index = i + j * retsuNum;       //現在の列番号、行番号から配列のインデックスを割り出す
      //マウスオーバーで円の半径を大きくする（小さくする）
      let kyori = dist(mouseX, mouseY, x[index], y[index]);
      let ir = 0;   //rの目標値
      if(kyori < r[index]){
        ir = 50.0;
      }else{
        ir = 20.0 / gyoNum * j;
      }
      r[index] = r[index] + (ir - r[index]) / 10.0;
      fill(shikiso[index], saido[index], 255);    //色相、彩度の配列を使って色を指定
      circle(x[index], y[index], r[index] * 2);   //円の描画
    }
  }
}
