/* 円をマトリクス状に2重に並べる+片方はマウスの方に行こうとする */
let retsuNum = 10;  //並べたい列数
let gyoNum = 10;    //並べたい行数
let x = new Array(retsuNum * gyoNum);   //ベースの円のx座標。並べたい列数×行数のぶんだけ配列を作る
let y = new Array(x.length);    //ベースの円のy座標
let r = new Array(x.length);    //ベースの円の半径
let xx = new Array(x.length);   //動く円のx座標
let yy = new Array(x.length);   //動く円のy座標
let rr = new Array(x.length);   //動く円の半径

function setup(){
  createCanvas(windowWidth, windowHeight);
  let marginX = 70;
  let marginY = 70;
  let totalW = (retsuNum - 1) * marginX;    //合計の横幅を計算する
  let totalH = (gyoNum - 1) * marginY;      //合計の縦幅を計算する
  let leftX = width / 2 - totalW / 2;       //一番左上の円のx座標を計算する
  let topY = height / 2 - totalH / 2;       //一番左上の円のy座標を計算する
  for(let i = 0; i < x.length; i = i + 1){
    let gyo = floor(i / retsuNum);    //iの値を1行あたりの列数（retsuNum）で割って、floor()関数で小数点以下を切り捨てると現在の行番号が出る。
    let retsu = i % retsuNum;         //iの値を1行あたりの列数（retsuNum）で割った余り（%）が現在の列数になる
    x[i] = leftX + retsu * marginX;     //指定番号のxに位置を代入（現在の列数 × xマージン）
    y[i] = topY + gyo * marginY;      //指定番号のyに位置を代入（現在の行数 × yマージン）
    xx[i] = x[i];   //小さい円のx, y座標は大きい円のx,y座標と同じに
    yy[i] = y[i];
    r[i] = 20.0;                    //指定番号のrに半径を代入
    rr[i] = 20.0;                   //指定番号のrに半径を代入
  }
}
function draw(){
  clear();
  blendMode(ADD);
  background(0);
  blendMode(LIGHTEST)
  for(let i = 0; i < x.length; i = i + 1){
    noStroke();
    fill(0, 0, 255);
    circle(x[i], y[i], r[i] * 2);       //ベースの円描画
    let kakudo = atan2(mouseY - y[i], mouseX - x[i]);   //マウスとx[i],y[i]との角度を求める
    let hankei = 15;    //大きい円の中心から小さい円の中心までの距離
    let ixx = x[i] + hankei * cos(kakudo);    //動く円のx座標の目標値を計算
    let iyy = y[i] + hankei * sin(kakudo);    //動く円のy座標の目標値を計算
    xx[i] = xx[i] + (ixx - xx[i]) / 10.0;     //xxをixxに近づける
    yy[i] = yy[i] + (iyy - yy[i]) / 10.0;     //yyをiyyに近づける
    noStroke();
    fill(255, 0, 0);
    circle(xx[i], yy[i], rr[i]*2);      //動く円の描画
  }
}
