/* 円をマトリクス状に並べる */
let retsuNum = 10;  //並べたい列数
let gyoNum = 10;    //並べたい行数
let x = new Array(retsuNum * gyoNum);   //x座標。並べたい列数×行数のぶんだけ配列を作る
let y = new Array(x.length);    //y座標
let r = new Array(x.length);    //半径
let shikiso = new Array(x.length);   //色相
let saido = new Array(x.length);   //彩度

function setup(){
  createCanvas(windowWidth, windowHeight);
  let marginX = 70;
  let marginY = 70;
  let totalW = (retsuNum - 1) * marginX;    //合計の横幅を計算する
  let totalH = (gyoNum - 1) * marginY;      //合計の縦幅を計算する
  let leftX = width / 2 - totalW / 2;       //一番左上の円のx座標を計算する
  let topY = height / 2 - totalH / 2;       //一番左上の円のy座標を計算する
  for(let i = 0; i < x.length; i = i + 1){
    let gyo = floor(i / retsuNum);    //iの値を1行あたりの列数（retsuNum）で割って、floor()関数で小数点以下を切り捨てると現在の行番号が出る。
    let retsu = i % retsuNum;         //iの値を1行あたりの列数（retsuNum）で割った余り（%）が現在の列数になる
    x[i] = leftX + retsu * marginX;     //指定番号のxに位置を代入（現在の列数 × xマージン）
    y[i] = topY + gyo * marginY;      //指定番号のyに位置を代入（現在の行数 × yマージン）
    r[i] = 20.0;                    //指定番号のrに半径を代入
    shikiso[i] = 255 - 255 / retsuNum * retsu;     //指定番号のshikisoに色相値を代入（列番号が0で255、列番号がretsuNumに等しくて0）
    saido[i] = 255 - 255 / gyoNum * gyo;       //指定番号のsaidoに彩度の値を代入（行番号が0で255、行番号がryoNumに等しくて0）
  }
}
function draw(){
  background(0);
  noStroke();
  colorMode(HSB);     //カラーモードをHSBに（色相、彩度、明度）
  for(let i = 0; i < x.length; i = i + 1){
    //マウスオーバーで円の半径を大きくする（小さくする）
    let kyori = dist(mouseX, mouseY, x[i], y[i]);
    if(kyori < r[i]){
      r[i] = r[i] + (50.0 - r[i]) / 10.0;
    }else{
      r[i] = r[i] + (20.0 - r[i]) / 10.0;
    }
    fill(shikiso[i], saido[i], 255);    //shikiso、saidoの値を使って色を指定
    circle(x[i], y[i], r[i] * 2);       //x, y, rの値を使って描画
  }
}
