/* 3次元空間にあるランダムな点群 */
let x = new Array(1000);   //点のx座標を入れておく
let y = new Array(x.length);   //点のy座標を入れておく
let z = new Array(x.length);   //点のz座標を入れておく
let screenZ = 200;   //投影面のz座標
let vpX = 0;   //消失点のx, y座標
let vpY = 0;
function setup(){
  createCanvas(windowWidth, windowHeight);
  //点の座標の初期化
  for(let i = 0; i < x.length; i = i + 1){
    x[i] = random(-width/2, width/2);   //x座標をランダムで
    y[i] = random(-height/2, height/2); //y座標をランダムで
    z[i] = -screenZ + random(700);      //z座標をランダムで
  }
}
function draw(){
  //消失点の位置を画面の中心に
  vpX = width/2;
  vpY = height/2;
  background(0);
  noStroke();
  for(let i = 0; i < x.length; i = i + 1){    //xの数だけ繰り返し
    if(z[i] > -screenZ){    //計算エラー防止
      let scale = screenZ / (screenZ + z[i]);    //点のz座標に応じた拡大率を計算
      let posX = vpX + x[i] * scale;    //拡大率に応じて、描画するx, y座標を求める
      let posY = vpY + y[i] * scale;
      let d = 1 + 1 * scale;      //拡大率に応じた直径の計算
      fill(0, 255, 0, 255 * scale);
      circle(posX, posY, d);
    }
    z[i] -= 1;      //z座標を減らす（手前に移動させる）
    //手前に来すぎてしまったらまた奥に戻す
    if(z[i] < -screenZ){
      z[i] = -screenZ + 700;    //zを奥にも戻す
    }
  }
}
